/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.driver;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;

public class StreamPipe {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private final InputStream in;
    private final OutputStream out;
    private final int bufferSize;
    private int size = 0;
    private LinkedList blocks = new LinkedList();
    private boolean outputClosed = false;
    private boolean inputClosed = false;
    private int waitCount = 0;

    public StreamPipe(int bufferSize) {
        this.in = new Input();
        this.out = new Output();
        this.bufferSize = bufferSize <= 0 ? 65536 : bufferSize;
    }

    public StreamPipe() {
        this(ServerManager.getConfig().streamBufferSize);
    }

    StreamPipe(InputStream in, OutputStream out) {
        this.in = in == null ? new Input() : in;
        this.out = out == null ? new Output() : out;
        this.bufferSize = ServerManager.getConfig().streamBufferSize;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public synchronized void closeInput() {
        this.inputClosed = true;
        this.blocks.clear();
        this.size = 0;
        this.notifyThis();
    }

    public synchronized void closeOutput() {
        this.outputClosed = true;
        this.notifyThis();
    }

    public synchronized void addData(byte[] b) throws IOException {
        if (this.outputClosed) {
            throw new RPCIOException(2003, "Stream closed.");
        }
        if (this.inputClosed) {
            return;
        }
        while (this.size >= this.bufferSize) {
            this.waitThis();
            if (!this.inputClosed) continue;
            return;
        }
        this.blocks.addLast(b);
        this.size += b.length;
        this.notifyThis();
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized byte[] getData() throws IOException {
        while (this.size == 0) {
            if (this.inputClosed) {
                throw new RPCIOException(2003, "Stream closed.");
            }
            if (this.outputClosed) {
                return null;
            }
            this.waitThis();
        }
        byte[] block = (byte[])this.blocks.removeFirst();
        this.size -= block.length;
        this.notifyThis();
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitThis() throws IOException {
        ++this.waitCount;
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            RPCException.throwIt(e);
        }
        finally {
            --this.waitCount;
        }
    }

    private void notifyThis() {
        if (this.waitCount > 0) {
            if (this.waitCount == 1) {
                this.notify();
            } else {
                this.notifyAll();
            }
        }
    }

    private class Output
    extends OutputStream {
        private boolean closed = false;
        private final byte[] buf;
        private int pos;

        Output() {
            this.buf = new byte[ServerManager.getConfig().blockBufferSize];
            this.pos = 0;
        }

        private void flush(boolean force) throws IOException {
            if (this.closed) {
                throw new RPCIOException(2003, "stream closed.");
            }
            if (this.pos == 0) {
                return;
            }
            if (!force && this.pos < this.buf.length) {
                return;
            }
            byte[] b = new byte[this.pos];
            System.arraycopy(this.buf, 0, b, 0, this.pos);
            this.pos = 0;
            StreamPipe.this.addData(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.buf[this.pos++] = (byte)b;
            this.flush(false);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int r = this.buf.length - this.pos;
                if (r > len) {
                    r = len;
                }
                System.arraycopy(b, off, this.buf, this.pos, r);
                off += r;
                len -= r;
                this.pos += r;
                this.flush(false);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void flush() throws IOException {
            this.flush(true);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.flush(true);
                this.closed = true;
                StreamPipe.this.closeOutput();
            }
        }
    }

    private class Input
    extends InputStream {
        private volatile boolean closed = false;
        private byte[] data = null;
        private int pos = 0;

        private Input() {
        }

        private int fetch() throws IOException {
            if (this.closed) {
                throw new RPCIOException(2003, "Stream closed.");
            }
            if (this.data == null || this.pos >= this.data.length) {
                this.data = StreamPipe.this.getData();
                this.pos = 0;
            }
            return this.data == null ? 0 : this.data.length - this.pos;
        }

        @Override
        public synchronized int available() {
            int size = StreamPipe.this.size();
            if (this.data != null && this.pos < this.data.length) {
                size += this.data.length - this.pos;
            }
            return size;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.fetch() <= 0) {
                return -1;
            }
            return 0xFF & this.data[this.pos++];
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int l = this.fetch();
            if (l <= 0) {
                return -1;
            }
            if (l > len) {
                l = len;
            }
            System.arraycopy(this.data, this.pos, b, off, l);
            this.pos += l;
            return l;
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                StreamPipe.this.closeInput();
            }
        }
    }
}

