/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.health.Constant;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCManagement;
import com.kingdee.bos.rpc.healthdegree.IRemoteHealthDegree;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.loadbalance.DefaultRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.LBManage;
import com.kingdee.bos.rpc.io.loadbalance.RPCServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import com.kingdee.bos.rpc.performance.StringPerformanceValue;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import org.apache.log4j.Logger;

public class DynamicFactorRPCServer
extends DefaultRPCServer {
    private static final Logger logger = Logger.getLogger(DynamicFactorRPCServer.class);
    private static final long retryTime = 120000L;
    private static final float pingInterval = 10000.0f;
    public static final int DEFAULTSOCKTIMEOUT = 10000;
    private float healthDegree;
    private Map healthReport = new HashMap();
    protected final PerformanceValue hd;
    private int sockTimeout = 10000;
    protected final PerformanceValue sto;
    public static final float DEFAULTDYNAMICEFFECT = 0.2f;
    private float dynamicEffect = 0.2f;
    private boolean remotePingFailed;
    private boolean lastRemotePingFailed;
    protected final PerformanceValue rpf;
    private long lastRemotePingTime;
    protected final PerformanceValue lrpt;
    private final ResponseTimeSample responseTimeSample = new ResponseTimeSample();
    protected final PerformanceValue rt;
    private volatile boolean stopFactorTester;

    public DynamicFactorRPCServer(String url, float performanceFactor, String standbyUrl, float dynamicEffect, int sockTimeout, String name) {
        super(url, performanceFactor, standbyUrl, name);
        this.setDynamicEffect(dynamicEffect);
        this.sockTimeout = sockTimeout;
        Thread t = new Thread((Runnable)new FactorTester(), "dynamicFactorRetriever[" + this.getUrlAndStandbyUrl() + "]");
        t.setDaemon(true);
        t.start();
        this.hd = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "HealthDegree"){

            @Override
            public Object value() {
                return String.valueOf(DynamicFactorRPCServer.this.getHealthDegree());
            }
        };
        PerformanceManager.setValue(this.hd);
        this.sto = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "SockTimeout"){

            @Override
            public Object value() {
                return String.valueOf(DynamicFactorRPCServer.this.sockTimeout);
            }
        };
        PerformanceManager.setValue(this.sto);
        this.rpf = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "remotePingFailed"){

            @Override
            public Object value() {
                return String.valueOf(DynamicFactorRPCServer.this.remotePingFailed);
            }
        };
        PerformanceManager.setValue(this.rpf);
        this.lrpt = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "lastRemotePingTime"){

            @Override
            public Object value() {
                return RPCServer.format.format(new Date(DynamicFactorRPCServer.this.lastRemotePingTime));
            }
        };
        PerformanceManager.setValue(this.lrpt);
        this.rt = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "lastResponseTime"){

            @Override
            public Object value() {
                return String.valueOf(DynamicFactorRPCServer.this.responseTimeSample);
            }
        };
        PerformanceManager.setValue(this.rt);
        logger.warn((Object)("DynamicFactorRetriever Thread for " + url + " started!"));
    }

    public DynamicFactorRPCServer(String url, float performanceFactor) {
        this(url, performanceFactor, null, 0.2f, 10000, null);
    }

    public DynamicFactorRPCServer(String url) {
        this(url, 1.0f);
    }

    @Override
    protected synchronized long getLastConnectTime() {
        if (this.remotePingFailed) {
            return this.lastRemotePingTime;
        }
        return super.getLastConnectTime();
    }

    @Override
    public synchronized float getPerformance() {
        if (this.lastRemotePingTime == 0L) {
            return super.getPerformance();
        }
        float rpt = this.responseTimeSample.getPerformance();
        if (rpt == -2.0f || rpt == -1.0f) {
            return rpt;
        }
        if (this.healthDegree == -2.0f || this.healthDegree == -1.0f) {
            return this.healthDegree;
        }
        return this.getPerformanceFactor() * (1.0f + rpt + this.dynamicEffect * this.healthDegree) / (float)(this.getConnectionCount() + 1);
    }

    private float getHealthDegree(Map report) {
        Map deadLockReport;
        Float degree = Float.valueOf(0.0f);
        if (report.get(Constant.DEAD_LOCK_CHECKED_INFO) != null) {
            deadLockReport = (Map)report.get(Constant.DEAD_LOCK_CHECKED_INFO);
            degree = Float.valueOf(degree.floatValue() + ((Float)deadLockReport.get(Constant.HEALTHSTATUSENUM)).floatValue());
        }
        if (report.get(Constant.MEMORY_REPORT) != null) {
            deadLockReport = (Map)report.get(Constant.MEMORY_REPORT);
            degree = Float.valueOf(degree.floatValue() + ((Float)deadLockReport.get(Constant.HEALTHSTATUSENUM)).floatValue());
        }
        if (report.get(Constant.AIS_LS) != null) {
            List dataSourceReport = (List)report.get(Constant.AIS_LS);
            for (Map map : dataSourceReport) {
                degree = Float.valueOf(degree.floatValue() + ((Float)map.get(Constant.HEALTHSTATUSENUM)).floatValue());
            }
        }
        return degree.floatValue();
    }

    protected synchronized void success(String url, Map healthReport) {
        this.remotePingFailed = false;
        this.connectFailed = false;
        this.lastRemotePingFailed = false;
        this.lastRemotePingTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getUrl() + " healthDegree is " + this.healthReport));
        }
        this.notify(url, healthReport);
    }

    protected synchronized void failed(String url) {
        this.remotePingFailed = true;
        this.healthDegree = -2.0f;
        Exception e = new Exception("Who is in subhealth");
        logger.error((Object)("Server  is in subhealth, server url=" + url), (Throwable)e);
        this.lastRemotePingTime = System.currentTimeMillis();
        this.healthReport.put(Constant.GET_HEALTH_FAILED, Constant.GET_HEALTH_FAILED);
        this.healthReport.put(Constant.URL, url);
        this.notify(url, this.healthReport);
    }

    private void notify(String url, Map healthReport) {
        healthReport.put(Constant.URL, url);
        long sequenceNumber = LBManage.getSequenceNumber();
        long timesnap = System.currentTimeMillis();
        Object hstatus = healthReport.get(Constant.HEALTHSTATUSENUM);
        if (hstatus == null || ((Float)hstatus).floatValue() == -2.0f || ((Float)hstatus).floatValue() == -1.0f) {
            Exception e = new Exception("Who send Notification,url=" + url + ",sequenceNumber=" + sequenceNumber + ",timesnap=" + timesnap);
            logger.error((Object)"Who send Notification", (Throwable)e);
        }
        try {
            Notification nf = new Notification(LBManage.HEALTH_DEGREE_RRPORT.getNotifTypes()[0], RPCServer.class.getName(), sequenceNumber, timesnap, "[" + url + "]" + LBManage.HEALTH_DEGREE_RRPORT.getDescription());
            nf.setUserData(healthReport);
            RPCManagement.MBEAN_SERVER.invoke(RPCManagement.mbeanObjectName, "sendNotification", new Notification[]{nf}, null);
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public synchronized boolean connectionFailed() {
        return this.remotePingFailed || super.connectionFailed();
    }

    @Override
    public synchronized float getHealthDegree() {
        return this.healthDegree;
    }

    @Override
    public void stop() {
        super.stop();
        this.stopFactorTester = true;
        PerformanceManager.removeValue(this.hd);
        PerformanceManager.removeValue(this.sto);
        PerformanceManager.removeValue(this.rpf);
        PerformanceManager.removeValue(this.lrpt);
        PerformanceManager.removeValue(this.rt);
    }

    public int getSockTimeout() {
        return this.sockTimeout;
    }

    public void setSockTimeout(int sockTimeout) {
        this.sockTimeout = sockTimeout;
    }

    public float getDynamicEffect() {
        return this.dynamicEffect;
    }

    public void setDynamicEffect(float dynamicEffect) {
        if (dynamicEffect >= 0.0f && dynamicEffect <= 1.0f) {
            this.dynamicEffect = dynamicEffect;
        }
    }

    static class ResponseTimeSample {
        private static final int SampleCount = 5;
        private long normalResponseTime = 0L;
        private long[] lastResponseTimes = new long[5];
        private int count = -10;

        ResponseTimeSample() {
        }

        synchronized void take(long responseTime) {
            if (this.count > 1000000) {
                this.count = 0;
            }
            ++this.count;
            if (this.count >= 0) {
                this.lastResponseTimes[this.count % this.lastResponseTimes.length] = responseTime;
            }
            if (this.normalResponseTime == 0L) {
                this.normalResponseTime = this.getNormalResponTime();
            }
        }

        synchronized float getPerformance() {
            long res = this.getResponseTime();
            float hd = 0.0f;
            if (res > 100000000000L) {
                hd = -2.0f;
                logger.error((Object)("oom hd=" + hd + ",res=" + res + ",normalResponseTime=" + this.normalResponseTime));
            } else if (res > 20000000000L) {
                hd = -1.0f;
                logger.error((Object)("oom min hd=" + hd + ",res=" + res + ",normalResponseTime=" + this.normalResponseTime));
            }
            return hd;
        }

        synchronized long getResponseTime() {
            long r = 0L;
            if (this.count > this.lastResponseTimes.length) {
                for (int i = 0; i < this.lastResponseTimes.length; ++i) {
                    r += this.lastResponseTimes[i];
                }
            }
            return r;
        }

        private long getNormalResponTime() {
            long obj = ServerManager.getConfig((String)"loadbalance").normalResponseTime;
            return obj * 1000000L * 5L;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    private class GetHealthDegree
    extends RPCServer.AbstractInvokeHandler {
        private int retryTime = 0;

        private GetHealthDegree() {
        }

        @Override
        public String getObjectName() {
            return "com.kingdee.bos.rpc.healthdegree.RemoteHealthDegree";
        }

        @Override
        public Class getModel() {
            return IRemoteHealthDegree.class;
        }

        @Override
        public Object execute(String url, Object target) throws Exception {
            IRemoteHealthDegree hd = (IRemoteHealthDegree)target;
            DynamicFactorRPCServer.this.healthReport = hd.getHealthDegree(url);
            DynamicFactorRPCServer.this.healthDegree = DynamicFactorRPCServer.this.getHealthDegree(DynamicFactorRPCServer.this.healthReport);
            if (DynamicFactorRPCServer.this.healthDegree >= 0.0f) {
                float rpt = DynamicFactorRPCServer.this.responseTimeSample.getPerformance();
                DynamicFactorRPCServer.this.healthDegree = rpt;
                if (rpt == -2.0f) {
                    DynamicFactorRPCServer.this.healthReport.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-2.0f));
                    DynamicFactorRPCServer.this.responseTimeSample.setCount(-10);
                } else if (rpt == -1.0f) {
                    DynamicFactorRPCServer.this.healthReport.put(Constant.HEALTHSTATUSENUM, Float.valueOf(-1.0f));
                } else {
                    DynamicFactorRPCServer.this.healthReport.put(Constant.HEALTHSTATUSENUM, Float.valueOf(0.0f));
                }
            }
            DynamicFactorRPCServer.this.success(url, DynamicFactorRPCServer.this.healthReport);
            this.retryTime = 0;
            return null;
        }

        @Override
        public boolean useStandby(String url, Exception e) {
            return true;
        }

        @Override
        public void handleException(String url, Exception e) {
            DynamicFactorRPCServer.this.lastRemotePingFailed = true;
            int errCode = RPCException.getErrorCode(e);
            if (errCode == 1005 || errCode == 1002) {
                logger.error((Object)("getHealthDegree failed and will ignored. url:" + url), (Throwable)e);
            } else if (500 == errCode) {
                if (this.retryTime < 5) {
                    ++this.retryTime;
                    logger.error((Object)("getHealthDegree failed and retry times:" + this.retryTime + ". url:" + url), (Throwable)e);
                } else {
                    this.retryTime = 0;
                    DynamicFactorRPCServer.this.responseTimeSample.setCount(-10);
                    logger.error((Object)("getHealthDegree failed and retry too more, will restart. url:" + url), (Throwable)e);
                    DynamicFactorRPCServer.this.failed(url);
                }
            } else {
                logger.error((Object)("getHealthDegree failed url:" + url), (Throwable)e);
                DynamicFactorRPCServer.this.responseTimeSample.setCount(-10);
                DynamicFactorRPCServer.this.failed(url);
            }
        }
    }

    class FactorTester
    implements Runnable {
        private final GetHealthDegree healthDegree;

        FactorTester() {
            this.healthDegree = new GetHealthDegree();
        }

        @Override
        public void run() {
            RPCConnection.initCurrentSockTimeout();
            while (!DynamicFactorRPCServer.this.stopFactorTester) {
                try {
                    RPCConnection.getCurrentSockTimeout().set(DynamicFactorRPCServer.this.sockTimeout);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (DynamicFactorRPCServer.this.remotePingFailed && System.currentTimeMillis() - DynamicFactorRPCServer.this.lastRemotePingTime < 120000L) continue;
                    long start = System.nanoTime();
                    this.getHealthDegree();
                    DynamicFactorRPCServer.this.broadcast();
                    if (DynamicFactorRPCServer.this.lastRemotePingFailed) {
                        DynamicFactorRPCServer.this.responseTimeSample.take(10000000000L);
                        continue;
                    }
                    DynamicFactorRPCServer.this.responseTimeSample.take(System.nanoTime() - start);
                }
                catch (Exception e) {
                    logger.error((Object)"DynamicFactorRPCServer.run", (Throwable)e);
                }
            }
            RPCConnection.getCurrentSockTimeout().set(null);
        }

        void getHealthDegree() {
            DynamicFactorRPCServer.super.invoke(this.healthDegree);
        }
    }
}

