/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class JobManager {
    private static final Logger logger = Logger.getLogger(JobManager.class);
    private static volatile RPCServerGroup rpcServers = null;

    public static void dispatch(TaskConf<? extends IORMModel> taskConf) throws BOSException {
        RPCServerGroup servers = JobManager.getServers();
        IRPCServer[] ss = servers.servers;
        if (ss.length > 0 && !servers.isLocal(ss[0])) {
            JobManager.invoke(ss[0].getUrl(), taskConf);
            return;
        }
        Task<? extends IORMModel> t = taskConf.getTask();
        if (t != null) {
            t.run(taskConf.getLocalInstance());
        }
    }

    public static boolean dispatch2Another(TaskConf<? extends IORMModel> taskConf) throws BOSException {
        IRPCServer[] ss = JobManager.getServers().others;
        if (ss.length > 0) {
            JobManager.invoke(ss[0].getUrl(), taskConf);
            return true;
        }
        return false;
    }

    public static void dispatch2Others(TaskConf<? extends IORMModel> taskConf) throws BOSException {
        IRPCServer[] ss = JobManager.getServers().others;
        for (int i = 0; i < ss.length; ++i) {
            JobManager.invoke(ss[i].getUrl(), taskConf);
        }
    }

    private static void invoke(String url, TaskConf<? extends IORMModel> taskConf) throws BOSException {
        Class[] types = taskConf.getArgumentTypes();
        Object[] args = taskConf.getArguments();
        IORMModel model = types != null ? RPCEngineFactory.getEngine(url).createObject(taskConf.getImplName(), taskConf.getInterface(), types, args) : RPCEngineFactory.getEngine(url).createObject(taskConf.getImplName(), taskConf.getInterface());
        Task<? extends IORMModel> t = taskConf.getTask();
        if (t != null) {
            t.run(model);
        }
    }

    public static RPCServerGroup getServers() {
        RPCServerView sv = RPCServerView.getLast();
        if (rpcServers != null && rpcServers.view == sv) {
            return rpcServers;
        }
        if (sv == null) {
            logger.info((Object)"no available server!");
            rpcServers = new RPCServerGroup(sv, new IRPCServer[0], new IRPCServer[0], new IRPCServer[0]);
        } else {
            IRPCServer[] ss = sv.getServers();
            ArrayList<IRPCServer> servers = new ArrayList<IRPCServer>(ss.length);
            ArrayList<IRPCServer> local = new ArrayList<IRPCServer>(ss.length);
            ArrayList<IRPCServer> others = new ArrayList<IRPCServer>(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                String url;
                IRPCServer s = ss[i];
                if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl()))) continue;
                if (JobManager.isLocal(url)) {
                    local.add(s);
                } else {
                    others.add(s);
                }
                servers.add(s);
            }
            ss = servers.toArray(new IRPCServer[0]);
            IRPCServer[] ls = local.toArray(new IRPCServer[0]);
            IRPCServer[] os = others.toArray(new IRPCServer[0]);
            rpcServers = new RPCServerGroup(sv, ss, ls, os);
        }
        return rpcServers;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    public static class RPCServerGroup
    implements Serializable {
        private static final long serialVersionUID = 8528742093798715774L;
        private final transient RPCServerView view;
        public final IRPCServer[] servers;
        public final IRPCServer[] local;
        public final IRPCServer[] others;

        RPCServerGroup(RPCServerView view, IRPCServer[] servers, IRPCServer[] local, IRPCServer[] others) {
            this.view = view;
            this.servers = servers;
            this.local = local;
            this.others = others;
        }

        public boolean isLocal(IRPCServer s) {
            for (int i = 0; i < this.local.length; ++i) {
                if (this.local[i] != s) continue;
                return true;
            }
            return false;
        }
    }

    public static interface TaskConf<T extends IORMModel> {
        public Class<T> getInterface();

        public String getImplName();

        public Class[] getArgumentTypes();

        public Object[] getArguments();

        public T getLocalInstance();

        public Task<T> getTask();
    }

    public static interface Task<T extends IORMModel> {
        public void run(T var1) throws BOSException;
    }
}

