/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.rpc.io.ServerManager;
import com.kingdee.bos.rpc.io.loadbalance.DefaultRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.DynamicFactorRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalance;
import com.kingdee.bos.rpc.io.loadbalance.RPCServer;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import com.kingdee.bos.rpcwrapper.LoadBalanceServerMain;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;

public class LBManage
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private static final Logger logger = Logger.getLogger(LBManage.class);
    public static final String REGISTER_SERVER = "registerServer";
    public static final String UNREGISTER_SERVER = "unregisterServer";
    public static final String SET_PERFORMANCE_FACTOR = "setPerformanceFactor";
    public static final String SET_SOCK_TIMEOUT = "setSockTimeout";
    public static final String SAVE_TO_FILE = "saveToFile";
    public static final String STATISTICS = "statistics";
    public static final String STOP = "stop";
    public static final String NT_HEALTH_DEGREE_IS_BAD = "healthDegreeIsBad";
    public static final String NT_LB_IS_SHUTDOWN = "lbIsShutdown";
    public static final String NT_JVM_IS_SHUTDOWN = "jvmIsShutdown";
    public static final String NT_STANDBY_FAILED = "standbyFailed";
    public static final String NT_HEALTH_DEGREE_REPORT = "healthDegreeReport";
    private static final String LOADBALANCE_PREFIX = "loadbalance.";
    public static final MBeanNotificationInfo HEALTH_DEGREE_IS_BAD = new MBeanNotificationInfo(new String[]{"healthDegreeIsBad"}, LBManage.class.getName(), "Server's health degree is bad!");
    public static final MBeanNotificationInfo LB_IS_SHUTDOWN = new MBeanNotificationInfo(new String[]{"lbIsShutdown"}, LBManage.class.getName(), "Load balance is shutdown!");
    public static final MBeanNotificationInfo JVM_IS_SHUTDOWN = new MBeanNotificationInfo(new String[]{"jvmIsShutdown"}, LBManage.class.getName(), "Jvm is shutdown!");
    public static final MBeanNotificationInfo STANDBY_FAILED = new MBeanNotificationInfo(new String[]{"standbyFailed"}, LBManage.class.getName(), "Standby server remotePing failed!");
    public static final MBeanNotificationInfo HEALTH_DEGREE_RRPORT = new MBeanNotificationInfo(new String[]{"healthDegreeReport"}, LBManage.class.getName(), "Server's health degree report!");
    private static long sequenceNumber;
    private static MBeanOperationInfo[] ops;

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        PerformanceValue value = PerformanceManager.getValue(attribute);
        if (value == null) {
            throw new AttributeNotFoundException(attribute);
        }
        return value.value();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList l = new AttributeList();
        PerformanceValue[] vs = PerformanceManager.getValues(attributes);
        for (int i = 0; i < vs.length; ++i) {
            if (vs[i] == null) continue;
            l.add(new Attribute(vs[i].name(), vs[i].value()));
        }
        return l;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        PerformanceValue[] pvs = PerformanceManager.getValues();
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[pvs.length];
        for (int i = 0; i < attrs.length; ++i) {
            PerformanceValue v = pvs[i];
            attrs[i] = new MBeanAttributeInfo(v.name(), v.type().getName(), v.name(), true, false, false);
        }
        return new MBeanInfo(LBManage.class.getName(), "LB Performance Monitor", attrs, null, ops, null);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public void registerServer(String url, float performanceFactor) {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        lb.registerServer(url, performanceFactor);
        lb.broadcast();
    }

    public void registerServer(String url, float performanceFactor, String standbyUrl, String name) {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        lb.registerServer(url, performanceFactor, standbyUrl, name);
        lb.broadcast();
    }

    public void unregisterServer(String url) {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        lb.unregisterServer(url);
        logger.info((Object)("LoadBalance unregisterServer " + url + " by LBManage!"));
    }

    public void setPerformanceFactor(String url, float performanceFactor) {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        lb.setPerformanceFactor(url, performanceFactor);
    }

    public void setSockTimeout(String url, int sockTimeout) {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        lb.setSockTimeout(url, sockTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile() {
        String config = System.getProperty("ormrpc.config");
        if (StringUtils.isEmpty((String)config)) {
            config = "ormrpc.properties";
        }
        Properties props = new Properties();
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(config);
            props.load(fs);
        }
        catch (Exception e) {
            logger.error((Object)("ORMRPC cannot load config file from [" + config + "]"), (Throwable)e);
            return;
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception ignore) {}
        }
        String[] keys = props.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].toLowerCase().startsWith(LOADBALANCE_PREFIX)) continue;
            props.remove(keys[i]);
        }
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        RPCServer[] ss = lb.getServersOriginOrder();
        for (int i = 0; i < ss.length; ++i) {
            RPCServer s = ss[i];
            String prefix = LOADBALANCE_PREFIX + i;
            props.setProperty(prefix, s.getInitUrl());
            if (s.getName() != null) {
                props.setProperty(prefix + ".name", s.getName());
            }
            if (s.getInitStandbyUrl() != null) {
                props.setProperty(prefix + ".standby.url", s.getInitStandbyUrl());
            }
            if (s instanceof DefaultRPCServer) {
                props.setProperty(prefix + ".capability", String.valueOf(((DefaultRPCServer)s).getPerformanceFactor()));
            }
            if (!(s instanceof DynamicFactorRPCServer)) continue;
            props.setProperty(prefix + ".standby.sockTimeout", String.valueOf(((DynamicFactorRPCServer)s).getSockTimeout()));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(config);
            props.store(fos, "Saved by LBManage");
        }
        catch (Exception e) {
            logger.error((Object)("ORMRPC cannot store config to file[" + config + "]"), (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    public Map statistics() {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        System.gc();
        Map map = lb.statistics();
        logger.info((Object)("LBManage statistics : " + map));
        return map;
    }

    public String[] getHdAndTcc() {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        String[] rt = new String[]{lb.hd.value().toString(), RPCServer.tcc.value().toString()};
        return rt;
    }

    public void stop() {
        logger.info((Object)"LBManage receive stop command!");
        if (LoadBalanceServerMain.server != null) {
            LoadBalanceServerMain.server.shutdown();
        }
        logger.warn((Object)"LoadBalance is shutdown by LBManage!");
        System.exit(0);
    }

    public boolean isWorking() {
        LoadBalance lb = (LoadBalance)ServerManager.getServer("default");
        return Boolean.valueOf(lb.workingPV.value().toString());
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (REGISTER_SERVER.equalsIgnoreCase(actionName)) {
            this.registerServer((String)params[0], ((Float)params[1]).floatValue());
        } else if (UNREGISTER_SERVER.equalsIgnoreCase(actionName)) {
            this.unregisterServer((String)params[0]);
        } else if (SET_PERFORMANCE_FACTOR.equalsIgnoreCase(actionName)) {
            this.setPerformanceFactor((String)params[0], ((Float)params[1]).floatValue());
        } else if (SET_SOCK_TIMEOUT.equalsIgnoreCase(actionName)) {
            this.setSockTimeout((String)params[0], (Integer)params[1]);
        } else if (SAVE_TO_FILE.equalsIgnoreCase(actionName)) {
            this.saveToFile();
        } else {
            if (STATISTICS.equalsIgnoreCase(actionName)) {
                return this.statistics();
            }
            if ("getHdAndTcc".equalsIgnoreCase(actionName)) {
                return this.getHdAndTcc();
            }
            if (STOP.equalsIgnoreCase(actionName)) {
                this.stop();
            } else if ("sendNotification".equalsIgnoreCase(actionName)) {
                this.sendNotification((Notification)params[0]);
            } else if (signature != null) {
                Class[] types = new Class[signature.length];
                try {
                    for (int i = 0; i < signature.length; ++i) {
                        types[i] = "int".endsWith(signature[i]) ? Integer.TYPE : ("float".equals(signature[i]) ? Float.TYPE : ("long".equals(signature[i]) ? Long.TYPE : ("double".equals(signature[i]) ? Double.TYPE : ("byte".equals(signature[i]) ? Byte.TYPE : ("char".equals(signature[i]) ? Character.TYPE : ("boolean".equals(signature[i]) ? Boolean.TYPE : ("short".equals(signature[i]) ? Short.TYPE : Class.forName(signature[i]))))))));
                    }
                    Method method = LBManage.class.getMethod(actionName, types);
                    return method.invoke((Object)this, params);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    throw new ReflectionException(e);
                }
            }
        }
        return null;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{HEALTH_DEGREE_IS_BAD, LB_IS_SHUTDOWN, JVM_IS_SHUTDOWN, STANDBY_FAILED, HEALTH_DEGREE_RRPORT};
    }

    @Override
    public void sendNotification(Notification notification) {
        logger.info((Object)notification.toString());
        super.sendNotification(notification);
    }

    public static synchronized long getSequenceNumber() {
        return sequenceNumber++;
    }

    static {
        ops = new MBeanOperationInfo[5];
        MBeanParameterInfo[] pi = new MBeanParameterInfo[]{new MBeanParameterInfo("url", "java.lang.String", "url"), new MBeanParameterInfo("performanceFactor", "float", "performanceFactor")};
        LBManage.ops[0] = new MBeanOperationInfo(REGISTER_SERVER, REGISTER_SERVER, pi, "void", 1);
        LBManage.ops[2] = new MBeanOperationInfo(SET_PERFORMANCE_FACTOR, SET_PERFORMANCE_FACTOR, pi, "void", 1);
        pi = new MBeanParameterInfo[]{new MBeanParameterInfo("url", "java.lang.String", "url")};
        LBManage.ops[1] = new MBeanOperationInfo(UNREGISTER_SERVER, UNREGISTER_SERVER, pi, "void", 1);
        pi = new MBeanParameterInfo[]{new MBeanParameterInfo("url", "java.lang.String", "url"), new MBeanParameterInfo("sockTimeout", "int", "sockTimeout")};
        LBManage.ops[3] = new MBeanOperationInfo(SET_SOCK_TIMEOUT, SET_SOCK_TIMEOUT, pi, "void", 1);
        LBManage.ops[4] = new MBeanOperationInfo(SAVE_TO_FILE, SAVE_TO_FILE, new MBeanParameterInfo[0], "void", 1);
    }
}

