/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCManagement;
import com.kingdee.bos.rpc.healthdegree.BaseHealthDegree;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.bos.rpc.impl.ServiceDispatcher;
import com.kingdee.bos.rpc.io.loadbalance.LBServerStat;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.SSLTCPServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.io.server.TCPServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoadBalanceLocalizer
implements IServer {
    private static Logger logger = Logger.getLogger(LoadBalanceLocalizer.class);
    private static ArrayList lbServers = new ArrayList();
    private TCPServer server;
    private SSLTCPServer sslServer;
    private int tcpPort = 11018;
    private int sslPort = 11019;
    private boolean dynamicFactor;
    public static final int DEFAULT_TCPPORT = 11018;
    public static final int DEFAULT_SSLPORT = 11019;
    public static final String CCL = "ccl";
    private IHealthDegree hd = new BaseHealthDegree();

    public LoadBalanceLocalizer(int tcpPort) {
        this.tcpPort = tcpPort;
    }

    public LoadBalanceLocalizer(int tcpPort, int sslPort) {
        this.tcpPort = tcpPort;
        this.sslPort = sslPort;
    }

    public LoadBalanceLocalizer(String name, String[] lbServes) {
        for (int i = 0; i < lbServes.length; ++i) {
            lbServers.add(lbServes[i]);
        }
    }

    public void registerServer(String url, float performanceFactor) {
        LBServerStat ss = new LBServerStat(url, performanceFactor);
        if (!lbServers.contains(ss)) {
            lbServers.add(ss);
        }
    }

    public void registerServer(String url, float performanceFactor, float dynamicEffect, int rmiPort) {
        LBServerStat ss = new LBServerStat(url, performanceFactor, dynamicEffect, rmiPort);
        if (!lbServers.contains(ss)) {
            lbServers.add(ss);
        }
    }

    public String connect() {
        if (!this.dynamicFactor) {
            return this.getUrlByCapability();
        }
        return this.getUrlByHealthDegree();
    }

    private String getUrlByCapability() {
        String redirectUrl = null;
        float max = -2.1474836E9f;
        LBServerStat mss = null;
        for (LBServerStat ss : lbServers) {
            if (!(ss.getPerformance() > max)) continue;
            max = ss.getPerformance();
            mss = ss;
            redirectUrl = ss.url;
        }
        if (mss != null) {
            ++mss.connectionCount;
        }
        return redirectUrl;
    }

    private String getUrlByHealthDegree() {
        String url;
        String redirectUrl = null;
        float max = Float.MIN_VALUE;
        LBServerStat mss = null;
        for (LBServerStat ss : lbServers) {
            url = ss.url;
            if (ss.isRemotePingFailed() || !(ss.getDynamicPerformance() > max)) continue;
            max = ss.getDynamicPerformance();
            mss = ss;
            redirectUrl = url;
        }
        if (redirectUrl == null) {
            for (LBServerStat ss : lbServers) {
                url = ss.url;
                if (!(ss.getDynamicPerformance() > max)) continue;
                max = ss.getDynamicPerformance();
                mss = ss;
                redirectUrl = url;
            }
        }
        if (mss != null) {
            ++mss.connectionCount;
        }
        return redirectUrl;
    }

    @Override
    public Map statistics() {
        return null;
    }

    @Override
    public boolean hasStandby() {
        return false;
    }

    @Override
    public void shutdown() {
        this.server.shutdown();
    }

    @Override
    public void start() {
        RPCManagement.registerMBean();
        if (this.server == null) {
            try {
                ORMRPConfig.loadConfig(CCL);
                this.server = new TCPServer(this, CCL, this.tcpPort);
                this.server.setDaemon(false);
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        this.server.start();
        if (ServerManager.getConfig((String)CCL).supportSSL) {
            if (this.sslServer == null) {
                try {
                    ORMRPConfig.loadConfig("ssl");
                    this.sslServer = new SSLTCPServer(this, this.sslPort);
                    this.sslServer.setDaemon(false);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            this.sslServer.start();
        }
    }

    @Override
    public RPCConfig getConfig() {
        return ServerManager.getConfig(CCL);
    }

    @Override
    public String getName() {
        return CCL;
    }

    public void setDynamicFactor(boolean dynamicFactor) {
        this.dynamicFactor = dynamicFactor;
    }

    @Override
    public ServiceDispatcher getServiceDispatcher() {
        return null;
    }

    @Override
    public Map getSessions() {
        return null;
    }

    @Override
    public Map getHealthDegree() {
        return new HashMap();
    }

    @Override
    public boolean match(String url) {
        if (url.startsWith("tcp:")) {
            return this.server.match(url);
        }
        if (url.startsWith("tcps:")) {
            return this.sslServer.match(url);
        }
        return false;
    }

    @Override
    public String getServerName() {
        return CCL;
    }

    private static InetSocketAddress getAddress(String url) throws UnknownHostException {
        int port;
        String host;
        int index = url.indexOf(47) + 2;
        int index1 = url.indexOf(47, index);
        String address = index1 < 0 ? url.substring(index) : url.substring(index, index1);
        index = address.indexOf(58);
        if (index < 0) {
            host = address;
            port = 11034;
        } else {
            host = address.substring(0, index);
            port = Integer.parseInt(address.substring(index + 1));
        }
        InetAddress addr = InetAddress.getByName(host);
        return new InetSocketAddress(addr, port);
    }
}

