/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.loadbalance;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventListener;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCManagement;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.ConnectionManager;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.IRemoteLBListenerManager;
import com.kingdee.bos.rpc.io.loadbalance.LBManage;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalance;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import com.kingdee.bos.rpc.performance.StringPerformanceValue;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.management.Notification;
import org.apache.log4j.Logger;

public abstract class RPCServer
implements Comparable,
IRPCServer {
    private static Logger logger = Logger.getLogger(RPCServer.class);
    private static final String TotalConnectionCount = "TotalConnectionCount";
    public static final IntValue tcc = PerformanceManager.getIntValue("TotalConnectionCount");
    protected static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final String url;
    private final String standbyUrl;
    private final String name;
    private boolean isStandby = false;
    private String engine_id = null;
    private int connectionCount = 0;
    protected boolean connectFailed = false;
    private long lastConnectTime = 0L;
    private final HashMap<String, Integer> clients = new HashMap();
    protected final IntValue cc;
    protected final PerformanceValue lct;
    protected final PerformanceValue cf;
    protected final PerformanceValue currentUrl;
    private LoadBalance lb;
    private ISession session;
    private final EventListener connectionListener = new EventListener(){

        @Override
        public void onEvent(Event e) {
            RPCServer.this.connectionClosed((ConnectionHelper)e.source);
        }
    };
    private volatile Broadcast broadcast = null;

    public RPCServer(String url, String standbyUrl, String name) {
        this.url = url;
        this.standbyUrl = standbyUrl;
        this.name = name;
        this.cc = PerformanceManager.getIntValue(TotalConnectionCount, "[" + this.getUrlAndStandbyUrl() + "]ConnectionCount");
        this.lct = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "LastConnectTime"){

            @Override
            public Object value() {
                return format.format(new Date(RPCServer.this.getLastConnectTime()));
            }
        };
        PerformanceManager.setValue(this.lct);
        this.cf = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "ConnectionFailed"){

            @Override
            public Object value() {
                return String.valueOf(RPCServer.this.connectionFailed());
            }
        };
        PerformanceManager.setValue(this.cf);
        this.currentUrl = new StringPerformanceValue("[" + this.getUrlAndStandbyUrl() + "]" + "CurrentUrl"){

            @Override
            public Object value() {
                return RPCServer.this.getUrl();
            }
        };
        PerformanceManager.setValue(this.currentUrl);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized boolean connectionFailed() {
        return this.connectFailed;
    }

    protected synchronized long getLastConnectTime() {
        return this.lastConnectTime;
    }

    @Override
    public synchronized String getEngineId() {
        return this.engine_id;
    }

    protected synchronized void connectionClosed(ConnectionHelper cn) {
        --this.connectionCount;
        this.cc.append(-1);
        this.reduceClient(cn.getConnectionProps().getProperty("route"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionHelper connect(Properties props) throws IOException {
        ConnectionHelper cn;
        String url = this.getUrl();
        try {
            cn = ConnectionManager.connect0(url, props);
        }
        catch (IOException e) {
            if (this.standbyUrl != null) {
                url = this.switchUrl();
                try {
                    cn = ConnectionManager.connect0(url, props);
                }
                catch (IOException e2) {
                    RPCServer rPCServer = this;
                    synchronized (rPCServer) {
                        this.connectFailed = true;
                        this.lastConnectTime = System.currentTimeMillis();
                    }
                    throw e2;
                }
            }
            RPCServer rPCServer = this;
            synchronized (rPCServer) {
                this.connectFailed = true;
                this.lastConnectTime = System.currentTimeMillis();
            }
            throw e;
        }
        boolean bradcast = false;
        RPCServer rPCServer = this;
        synchronized (rPCServer) {
            this.connectFailed = false;
            this.lastConnectTime = System.currentTimeMillis();
            if (this.engine_id != null && !this.engine_id.equals(cn.getEngineId())) {
                bradcast = true;
            }
            this.engine_id = cn.getEngineId();
            ++this.connectionCount;
            this.cc.append(1);
            this.increaseClient(props.getProperty("route"));
        }
        cn.addEventListener(CloseEvent.class, this.connectionListener);
        if (bradcast) {
            this.lb.broadcast();
        }
        if (!bradcast && !ServerManager.getConfig((String)"loadbalance").dynamicFactor) {
            this.broadcast();
        }
        return cn;
    }

    private void increaseClient(String client) {
        Integer counter = this.clients.get(client);
        int count = 0;
        if (counter != null && counter instanceof Integer) {
            count = counter;
        }
        this.clients.put(client, count + 1);
    }

    private void reduceClient(String client) {
        Integer counter = this.clients.get(client);
        int count = 0;
        if (counter != null && counter instanceof Integer) {
            count = counter;
        }
        if (count > 1) {
            this.clients.put(client, count - 1);
        } else {
            this.clients.remove(client);
        }
    }

    @Override
    public synchronized int getConnectionCount() {
        return this.connectionCount;
    }

    protected synchronized String switchUrl() {
        String result;
        if (this.isStandby) {
            String old = this.standbyUrl;
            result = this.url;
        } else {
            String old = this.url;
            result = this.standbyUrl;
        }
        this.isStandby = !this.isStandby;
        return result;
    }

    protected void sendNotification(String url) {
        this.sendNotification(url, true);
    }

    protected void sendNotification(String url, boolean force) {
        if (!force) {
            for (int i = 0; i < 2; ++i) {
                System.gc();
            }
            int connectionCount = this.getConnectionCount();
            if (connectionCount > 5) {
                logger.info((Object)("sendNotification to " + url + " is delayed. connectionCount is " + connectionCount));
                return;
            }
        }
        long sequenceNumber = LBManage.getSequenceNumber();
        long timesnap = System.currentTimeMillis();
        Exception e = new Exception("Who send Notification,url=" + url + ",sequenceNumber=" + sequenceNumber + ",timesnap=" + timesnap);
        logger.error((Object)"Who send Notification", (Throwable)e);
        try {
            Notification nf = new Notification(LBManage.HEALTH_DEGREE_IS_BAD.getNotifTypes()[0], RPCServer.class.getName(), sequenceNumber, timesnap, "[" + url + "]" + LBManage.HEALTH_DEGREE_IS_BAD.getDescription());
            nf.setUserData(url);
            RPCManagement.MBEAN_SERVER.invoke(RPCManagement.mbeanObjectName, "sendNotification", new Notification[]{nf}, null);
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
    }

    public String getUrlAndStandbyUrl() {
        return this.url + (this.standbyUrl != null ? ";" + this.standbyUrl : "");
    }

    public String getInitUrl() {
        return this.url;
    }

    public String getInitStandbyUrl() {
        return this.standbyUrl;
    }

    public void stop() {
        PerformanceManager.removeValue(this.lct);
        PerformanceManager.removeValue(this.cc);
        PerformanceManager.removeValue(this.cf);
        PerformanceManager.removeValue(this.currentUrl);
    }

    @Override
    public synchronized String getUrl() {
        return this.isStandby ? this.standbyUrl : this.url;
    }

    synchronized void setLoadBalance(LoadBalance lb) {
        this.broadcast = new Broadcast(lb);
        this.lb = lb;
    }

    public void broadcast() {
        this.invoke(this.broadcast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invoke(InvokeHandler handler) {
        block21: {
            if (handler == null) {
                return;
            }
            String url = this.getUrl();
            IORMModel orm = null;
            try {
                String string = url;
                synchronized (string) {
                    if (this.session == null) {
                        this.session = RPCEngineFactory.getEngine(url).createSession();
                    }
                    orm = this.session.createObject(handler.getObjectName(), handler.getModel());
                }
                handler.execute(url, orm);
            }
            catch (Exception e) {
                String string = url;
                synchronized (string) {
                    if (this.session != null) {
                        this.session.close();
                        this.session = null;
                    }
                }
                if (!handler.useStandby(url, e)) break block21;
                if (this.standbyUrl != null) {
                    url = this.switchUrl();
                    try {
                        string = url;
                        synchronized (string) {
                            this.session = RPCEngineFactory.getEngine(url).createSession();
                            orm = this.session.createObject(handler.getObjectName(), handler.getModel());
                        }
                        handler.execute(url, orm);
                    }
                    catch (Exception e2) {
                        String string2 = url;
                        synchronized (string2) {
                            if (this.session != null) {
                                this.session.close();
                                this.session = null;
                            }
                        }
                        handler.handleException(url, e2);
                    }
                }
                handler.handleException(url, e);
            }
        }
    }

    private static class Broadcast
    extends AbstractInvokeHandler {
        private final LoadBalance lb;

        Broadcast(LoadBalance lb) {
            this.lb = lb;
        }

        @Override
        public String getObjectName() {
            return "com.kingdee.bos.rpc.io.loadbalance.RemoteLBListenerManager";
        }

        @Override
        public Class getModel() {
            return IRemoteLBListenerManager.class;
        }

        @Override
        public Object execute(String url, Object target) throws Exception {
            IRemoteLBListenerManager lm = (IRemoteLBListenerManager)target;
            RPCServerView sv = new RPCServerView(this.lb.getServers());
            lm.broadcast(sv);
            return null;
        }

        @Override
        public void handleException(String url, Exception e) {
            logger.error((Object)("broadcast failed! server:" + url), (Throwable)e);
        }
    }

    protected static abstract class AbstractInvokeHandler
    implements InvokeHandler {
        private int retryTimes_connectFailed = 0;

        protected AbstractInvokeHandler() {
        }

        @Override
        public boolean useStandby(String url, Exception e) {
            int errCode = RPCException.getErrorCode(e);
            if (errCode == 1005) {
                logger.info((Object)("Server is restart. server:" + url), (Throwable)e);
                return false;
            }
            if (errCode == 1002) {
                logger.error((Object)("Session not found, will retry. server:" + url), (Throwable)e);
                return false;
            }
            if (e instanceof RPCConnectException && ((RPCConnectException)e).getType() == 6002) {
                if (this.retryTimes_connectFailed < 3) {
                    ++this.retryTimes_connectFailed;
                    logger.error((Object)("Meet RPCConnectException, will retry. server:" + url), (Throwable)e);
                    return false;
                }
                this.retryTimes_connectFailed = 0;
            }
            return true;
        }
    }

    protected static interface InvokeHandler {
        public String getObjectName();

        public Class getModel();

        public Object execute(String var1, Object var2) throws Exception;

        public boolean useStandby(String var1, Exception var2);

        public void handleException(String var1, Exception var2);
    }
}

