/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.nio;

import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.nio.NIOManager;
import com.kingdee.bos.rpc.io.nio.NIOSocket;
import com.kingdee.bos.rpc.io.server.ServerManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class NIOSelector
extends Thread {
    private static final Logger logger = Logger.getLogger(NIOSelector.class);
    public final Selector selector;
    private final ArrayList registerList = new ArrayList();
    private final ArrayList cancelList = new ArrayList();
    private int connectionCount = 0;

    public NIOSelector() throws IOException {
        super("RPC-NIO-Selector");
        this.selector = Selector.open();
        this.start();
    }

    public synchronized int getConnectionCount() {
        return this.connectionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectorLoop() throws Throwable {
        int n = this.selector.select(ServerManager.getConfig().nioSelectTimeout);
        if (n == 0) {
            return;
        }
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> ite = keys.iterator();
        while (ite.hasNext()) {
            try {
                this.selected(ite.next());
            }
            catch (Throwable e) {
                IOUtil.logIOError(logger, e);
            }
            ite.remove();
        }
    }

    private void selected(SelectionKey key) throws Exception {
        NIOSocket sock = (NIOSocket)key.attachment();
        if (key.isReadable()) {
            sock.notifyReadable();
        }
        if (key.isWritable()) {
            sock.notifyWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)(this.getName() + " start."));
        while (this.check()) {
            try {
                int count = this.selector.keys().size();
                NIOSelector nIOSelector = this;
                synchronized (nIOSelector) {
                    this.connectionCount = count;
                }
                if (count == 0 && NIOManager.notifyFree(this)) {
                    count = this.selector.keys().size();
                    if (count == 0) break;
                    nIOSelector = this;
                    synchronized (nIOSelector) {
                        this.connectionCount = count;
                    }
                    NIOManager.notifyReuse(this);
                }
                this.selectorLoop();
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }
        IOUtil.close(this.selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(NIOSocket sock) throws IOException {
        ArrayList arrayList = this.registerList;
        synchronized (arrayList) {
            sock.channel.configureBlocking(false);
            this.registerList.add(sock);
        }
        this.selector.wakeup();
    }

    public void registerAndWait(NIOSocket sock) throws IOException {
        this.register(sock);
        sock.waitForRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(NIOSocket sock) {
        ArrayList arrayList = this.cancelList;
        synchronized (arrayList) {
            this.cancelList.add(sock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check() {
        NIOSocket[] socks = null;
        ArrayList arrayList = this.registerList;
        synchronized (arrayList) {
            if (this.registerList.size() > 0) {
                socks = this.registerList.toArray(new NIOSocket[this.registerList.size()]);
                this.registerList.clear();
            }
        }
        if (socks != null) {
            for (int i = 0; i < socks.length; ++i) {
                try {
                    socks[i].register(this);
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)e, e);
                }
            }
        }
        ArrayList i = this.cancelList;
        synchronized (i) {
            if (this.cancelList.size() > 0) {
                socks = this.cancelList.toArray(new NIOSocket[this.registerList.size()]);
                this.cancelList.clear();
            } else {
                socks = null;
            }
        }
        if (socks != null) {
            for (int i2 = 0; i2 < socks.length; ++i2) {
                socks[i2].finalClose();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void select(SelectionKey key, boolean b, int mask, boolean wakeup) {
        if (key != null) {
            SelectionKey selectionKey = key;
            synchronized (selectionKey) {
                int ops = key.interestOps();
                int opsNew = b ? ops | mask : ops & ~mask;
                if (opsNew != ops) {
                    key.interestOps(opsNew);
                    if (wakeup) {
                        key.selector().wakeup();
                    }
                }
            }
        }
    }

    public static void selectRead(SelectionKey key, boolean b, boolean wakeup) {
        NIOSelector.select(key, b, 1, wakeup);
    }

    public static void selectWrite(SelectionKey key, boolean b, boolean wakeup) {
        NIOSelector.select(key, b, 4, wakeup);
    }

    public static ByteBuffer allocateBuffer() {
        return ByteBuffer.allocate(ServerManager.getConfig().blockBufferSize);
    }
}

