/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.server;

import com.kingdee.bos.rpc.Event;
import com.kingdee.bos.rpc.EventListener;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.RPCMonitor;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.impl.ServiceDispatcher;
import com.kingdee.bos.rpc.impl.UniqueID;
import com.kingdee.bos.rpc.io.ConnectionBase;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.io.driver.InternalConnectionHelper;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.IntValue;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class HttpServer
extends HttpServlet
implements IServer {
    private static final Logger logger;
    public static final String AGENT = "Kingdee BOS-RPC V2.0";
    public static final String USER_AGENT = "User-Agent";
    public static final char CREATE = 'N';
    public static final char INVOKE = 'I';
    public static final char CLOSE = 'C';
    public static final char OK = 'O';
    public static final char ERROR = 'E';
    public static final String RPC_CONTENT_TYPE = "RPCInvoke";
    private static final HashMap cns;
    public static final String DEFAULT = "default";
    protected String serverName = "default";
    private ServiceDispatcher dispatcher;
    private HashMap sessions;

    public HttpServer() {
        ServerManager.registerServer(this);
    }

    protected abstract ConnectionHelper createConnection(HttpServletRequest var1, Properties var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CnItem item;
        String agent = req.getHeader(USER_AGENT);
        if (agent == null || !agent.equalsIgnoreCase(AGENT)) {
            throw new ServletException("This url is reserved for Kingdee BOS-RPC.");
        }
        DataInputStream in = new DataInputStream((InputStream)req.getInputStream());
        DataOutputStream out = new DataOutputStream((OutputStream)resp.getOutputStream());
        int f = ((InputStream)in).read();
        if (f == 78) {
            Properties props = IOUtil.readProperties(in, null);
            try {
                ConnectionHelper cn = this.createConnection(req, props);
                ((ConnectionBase)cn).setServer(this);
                CnItem item2 = new CnItem(cn, req.getServletPath());
                HashMap hashMap = cns;
                synchronized (hashMap) {
                    cns.put(item2.id, item2);
                }
                IOUtil.writeLine(out, 'O' + item2.id);
                IOUtil.writeLine(out, cn.getConnectionProps().getProperty("engineId"));
            }
            catch (Throwable e) {
                IOUtil.writeLine(out, 'E' + e.toString());
            }
            return;
        }
        if (f == 67) {
            CnItem item3;
            String id = IOUtil.readLine(in);
            HashMap item2 = cns;
            synchronized (item2) {
                item3 = (CnItem)cns.get(id);
            }
            if (item3 != null) {
                item3.close();
            }
            IOUtil.writeLine(out, "Oconnection #" + id + " closed.");
            return;
        }
        String id = IOUtil.readLine(in);
        HashMap item2 = cns;
        synchronized (item2) {
            item = (CnItem)cns.get(id);
        }
        if (item == null) {
            IOUtil.writeLine(out, "Econnection #" + id + " not exist or timeout.");
            return;
        }
        item.enter();
        ByteArrayOutputStream bout = null;
        try {
            if (item.cn instanceof InternalConnectionHelper) {
                out.write(79);
                InvokeHelper helper = ((InternalConnectionHelper)item.cn).newInvokeHelper(in, out);
                RPCService.service(IOManager.createInvokeHelper(null, helper, false));
                resp.setContentLength(out.size());
            } else {
                bout = new ByteArrayOutputStream();
                bout.write(79);
                IOManager.redirect(item.cn, in, bout);
                bout.close();
                resp.setContentLength(bout.size());
                bout.writeTo(out);
            }
        }
        catch (Throwable e) {
            IOUtil.writeLine(out, 'E' + e.toString());
            return;
        }
        finally {
            item.leave();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream out = resp.getOutputStream();
        out.println("<HTML>");
        out.println("<TITLE>Http connection server(2.0)</TITLE>");
        out.println("<BODY>");
        out.println("<H1>Kingdee BOS RPC Http-Connection Server(2.0)</H1>");
        out.println("</BODY></HTML>");
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Map statistics() {
        return null;
    }

    @Override
    public boolean hasStandby() {
        return false;
    }

    @Override
    public RPCConfig getConfig() {
        ServerManager.setCurrentServer(this.serverName);
        RPCConfig config = ServerManager.getConfig();
        ServerManager.setCurrentServer(null);
        return config;
    }

    @Override
    public String getName() {
        return this.serverName;
    }

    @Override
    public ServiceDispatcher getServiceDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new ServiceDispatcher(this.serverName);
        }
        return this.dispatcher;
    }

    @Override
    public Map getSessions() {
        if (this.sessions == null) {
            this.sessions = PerformanceManager.createHashMap(this.serverName + "." + "ServerSession.count");
        }
        return this.sessions;
    }

    @Override
    public boolean match(String url) {
        return false;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public Map getHealthDegree() {
        return null;
    }

    static {
        IOUtil.initLog4j();
        RPCEngine.class.getClass();
        logger = Logger.getLogger(HttpServer.class);
        cns = new HashMap();
    }

    private static class CnItem
    implements Runnable {
        final ConnectionHelper cn;
        final String id;
        private long lastTime = System.currentTimeMillis();
        private final IntValue counter;
        private int refs = 0;
        private boolean closed = false;

        CnItem(final ConnectionHelper cn, String url) throws IOException {
            this.cn = cn;
            cn.addEventListener(CloseEvent.class, new EventListener(){

                @Override
                public void onEvent(Event ent) {
                    cn.removeEventListener(CloseEvent.class, this);
                    CnItem.this.close();
                }
            });
            this.id = UniqueID.next();
            this.reset();
            RPCMonitor.addMonitor(this);
            this.counter = PerformanceManager.getIntValue("Connection.http.count", "Connection.http.count." + url);
            this.counter.append(1);
        }

        @Override
        public void run() {
            if (this.isTimeout()) {
                logger.warn((Object)("Connection#" + this.id + " timeout."));
                this.close();
            }
        }

        void reset() {
            this.lastTime = System.currentTimeMillis();
        }

        synchronized void enter() {
            ++this.refs;
            this.reset();
        }

        synchronized void leave() {
            --this.refs;
            this.reset();
        }

        synchronized boolean isTimeout() {
            return this.refs == 0 && System.currentTimeMillis() - this.lastTime >= ServerManager.getConfig().httpConnectionTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = this;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.counter.append(-1);
            IOUtil.close(this.cn);
            RPCMonitor.removeMonitor(this);
            object = cns;
            synchronized (object) {
                cns.remove(this.id);
            }
        }

        protected void finalize() {
            this.close();
        }
    }
}

