/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.server;

import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.io.server.TCPServer;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.netty.handler.AbstractRpcServiceHandler;
import com.kingdee.bos.rpc.netty.handler.RpcClusterServiceHandler;
import com.kingdee.bos.rpc.netty.handler.RpcInstanceServiceHandler;
import com.kingdee.bos.rpc.netty.handler.RpcServerIdleHandler;
import com.kingdee.util.StringUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NettyServer
extends TCPServer {
    private int port;
    private boolean standby;
    private final String redirectUrl;
    private EventLoopGroup boss = new NioEventLoopGroup();
    private EventLoopGroup worker = new NioEventLoopGroup();
    private ChannelInitializer<SocketChannel> rpcIniter = null;
    private volatile String ip = null;

    public NettyServer(int port) throws IOException {
        this("default", port, null);
    }

    public NettyServer() throws IOException {
        this(11034);
    }

    public NettyServer(String serverName, int port, String redirectUrl) throws IOException {
        this.setName("RPC-NETTY-" + serverName + "(" + port + ")");
        this.setDaemon(true);
        this.port = port;
        this.serverName = serverName;
        this.redirectUrl = redirectUrl;
        this.standby = ServerManager.getConfig((String)serverName).standby;
        ServerManager.registerServer(this);
    }

    @Override
    protected ServerSocket createServerSocket(int port) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot() throws Exception {
        NettyHook hook = new NettyHook();
        Runtime.getRuntime().addShutdownHook(hook);
        final NettyServer server = this;
        this.rpcIniter = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch2) throws Exception {
                ByteBuf byteBuf = RpcNettyConstant.getDelimiterByByteBuf();
                long testInterval = ServerManager.getConfig().pooledSocketTestIntervalTime * 10L;
                ch2.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, byteBuf)});
                ch2.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(testInterval, 0L, 0L, TimeUnit.SECONDS));
                ch2.pipeline().addLast("RpcServerIdleHandler", (ChannelHandler)new RpcServerIdleHandler());
                AbstractRpcServiceHandler rpcServiceHandler = null;
                rpcServiceHandler = StringUtils.isEmpty((String)NettyServer.this.redirectUrl) ? new RpcInstanceServiceHandler(server) : new RpcClusterServiceHandler(server);
                ch2.pipeline().addLast("channelHandler", (ChannelHandler)rpcServiceHandler);
            }
        };
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)((ServerBootstrap)b.group(this.boss, this.worker).channel(NioServerSocketChannel.class)).localAddress(this.port)).childHandler(this.rpcIniter);
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        finally {
            this.boss.shutdownGracefully();
            this.worker.shutdownGracefully();
        }
    }

    @Override
    public void run() {
        block13: {
            if (this.standby) {
                logger.info((Object)(this.getName() + " standby."));
                boolean first = true;
                while (true) {
                    try {
                        Socket sock = new Socket(InetAddress.getByName(null), this.port);
                        if (first) {
                            logger.warn((Object)("port " + this.port + " already in use!"));
                            first = false;
                        }
                        IOUtil.close(sock);
                    }
                    catch (UnknownHostException e) {
                        logger.error((Object)"standby socket create error.", (Throwable)e);
                    }
                    catch (IOException e1) {
                        try {
                            this.boot();
                            break block13;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    try {
                        Thread.sleep(this.interval);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"terminate loop create socket.", (Throwable)e);
                        break block13;
                    }
                }
            }
            try {
                this.boot();
            }
            catch (Exception e) {
                if (e instanceof BindException) {
                    logger.error((Object)(this.port + " port already in use!"));
                    throw new RuntimeException(e);
                }
                logger.error((Object)"Server socket create error.", (Throwable)e);
            }
        }
    }

    public void removeHealthDegree() {
        this.hd = null;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    public boolean match(String url) {
        Set<String> set = this.getAllIPS();
        if (this.ip == null) {
            try {
                this.ip = InetAddress.getLocalHost().getHostAddress();
                if (!set.contains(this.ip)) {
                    set.add(this.ip);
                }
            }
            catch (UnknownHostException e) {
                this.ip = "127.0.0.1";
                logger.error((Object)("UnknownHostException:" + NettyServer.class.getName()), (Throwable)e);
            }
        }
        int index = url.indexOf("//");
        String ip2 = null;
        ip2 = index < 0 ? url.substring(0, url.lastIndexOf(":")) : url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
        String temp = url.substring(url.lastIndexOf(":") + 1);
        int port2 = Integer.parseInt(temp);
        if ("0.0.0.0".equals(this.ip) || "localhost".equalsIgnoreCase(ip2) || "127.0.0.1".equals(ip2)) {
            return this.port == port2;
        }
        return this.port == port2 && set.contains(ip2);
    }

    private class NettyHook
    extends Thread {
        private NettyHook() {
        }

        @Override
        public void run() {
            try {
                NettyServer.this.boss.shutdownGracefully();
                NettyServer.this.worker.shutdownGracefully();
            }
            catch (Exception e) {
                TCPServer.logger.error((Object)e);
            }
        }
    }
}

