/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.server;

import com.kingdee.bos.rpc.io.loadbalance.LoadBalanceLocalizer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.io.server.TCPServer;
import com.kingdee.bos.rpc.ssl.SSLSecurityProivder;
import com.kingdee.util.StringUtils;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;

public class SSLTCPServer
extends TCPServer {
    public static final int DEFAULT_PORT = 11033;
    public static final String DEFAULTNAME = "ssl";

    public SSLTCPServer(ServerSocket serverSocket, String redirectUrl) {
        super("SSLServer", serverSocket, redirectUrl);
    }

    public SSLTCPServer(int port, String redirectUrl) throws Exception {
        this("SSLServer", port, redirectUrl);
    }

    public SSLTCPServer(int port) throws Exception {
        this(port, null);
    }

    public SSLTCPServer() throws Exception {
        this(11033);
    }

    public SSLTCPServer(String serverName, int port) throws Exception {
        this(serverName, port, null);
    }

    public SSLTCPServer(String serverName, ServerSocket serverSocket, String redirectUrl) {
        super(serverName, serverSocket, redirectUrl);
    }

    public SSLTCPServer(String serverName, int port, String redirectUrl) throws Exception {
        super(serverName, port, redirectUrl);
    }

    public SSLTCPServer(LoadBalanceLocalizer lbl, int port) throws Exception {
        this(port);
        this.lbl = lbl;
    }

    @Override
    protected ServerSocket createServerSocket(int port) throws Exception {
        SSLSecurityProivder provider = SSLSecurityProivder.getRPCSSLSecurityProivder();
        SSLContext ctx = provider.getServerContext();
        ServerSocket ss = null;
        if (ServerManager.getConfig((String)this.serverName).reuseAddress == null) {
            ss = ctx.getServerSocketFactory().createServerSocket(port);
        } else {
            ss = ctx.getServerSocketFactory().createServerSocket();
            ss.setReuseAddress(ServerManager.getConfig((String)this.serverName).reuseAddress);
            InetSocketAddress endpoint = new InetSocketAddress(port);
            ss.bind(endpoint);
        }
        if (ss instanceof SSLServerSocket) {
            SSLServerSocket ssc = (SSLServerSocket)ss;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UseClientMode:" + ssc.getUseClientMode()));
            }
            ssc.setUseClientMode(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EnabledCipherSuites:" + StringUtils.arrayToString((Object[])ssc.getEnabledCipherSuites(), (String)",")));
                logger.debug((Object)("NeedClientAuth:" + ssc.getNeedClientAuth()));
                logger.debug((Object)("SupportedCipherSuites:" + StringUtils.arrayToString((Object[])ssc.getSupportedCipherSuites(), (String)",")));
            }
        }
        return ss;
    }
}

