/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.server;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.io.server.IServer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ServerManager {
    public static final String DEFAULT_SERVER_NAME = "";
    private static final HashMap servers = new HashMap();
    private static final Map cfgMap = new HashMap();
    private static final ThreadLocal currentServer = new ThreadLocal();
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServer(IServer server) {
        HashMap hashMap = servers;
        synchronized (hashMap) {
            servers.put(ServerManager._name(server.getName()), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterServer(IServer server) {
        HashMap hashMap = servers;
        synchronized (hashMap) {
            servers.remove(ServerManager._name(server.getName()));
        }
    }

    public static Map getServers() {
        return servers;
    }

    private static String _name(String s) {
        if (s == null || s.trim().length() == 0) {
            return DEFAULT_SERVER_NAME;
        }
        return s.toLowerCase();
    }

    public static void getServer(String name) {
        servers.get(ServerManager._name(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServer[] listServers() {
        HashMap hashMap = servers;
        synchronized (hashMap) {
            return servers.values().toArray(new IServer[servers.size()]);
        }
    }

    public static String getCurrentServer() {
        return (String)currentServer.get();
    }

    public static void setCurrentServer(String serverName) {
        currentServer.set(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPCConfig getConfig() {
        Object cfg;
        String serverName = (String)currentServer.get();
        if (serverName == null) {
            return ServerManager.getDefaultConfig();
        }
        try {
            rwl.readLock().lock();
            cfg = cfgMap.get(serverName);
        }
        finally {
            rwl.readLock().unlock();
        }
        if (cfg == null) {
            ORMRPConfig.loadConfig(serverName);
            try {
                rwl.readLock().lock();
                cfg = cfgMap.get(serverName);
            }
            finally {
                rwl.readLock().unlock();
            }
        }
        return (RPCConfig)cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getConfigs() {
        HashMap hm = new HashMap();
        try {
            rwl.readLock().lock();
            hm.putAll(cfgMap);
            HashMap hashMap = hm;
            return hashMap;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(RPCConfig newConfig) {
        String name = (String)currentServer.get();
        try {
            rwl.writeLock().lock();
            if (name != null) {
                cfgMap.put(name, newConfig);
            } else {
                cfgMap.put("default", newConfig);
            }
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPCConfig getConfig(String serverName) {
        try {
            rwl.readLock().lock();
            RPCConfig conf = (RPCConfig)cfgMap.get(serverName);
            if (conf != null) {
                RPCConfig rPCConfig = conf;
                return rPCConfig;
            }
        }
        finally {
            rwl.readLock().unlock();
        }
        ORMRPConfig.loadConfig(serverName);
        try {
            rwl.readLock().lock();
            RPCConfig rPCConfig = (RPCConfig)cfgMap.get(serverName);
            return rPCConfig;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    public static RPCConfig getDefaultConfig() {
        return ServerManager.getConfig("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(String serverName, RPCConfig newConfig) {
        try {
            rwl.writeLock().lock();
            cfgMap.put(serverName, newConfig);
        }
        finally {
            rwl.writeLock().unlock();
        }
    }
}

