/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.io.server;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.rpc.healthdegree.BaseHealthDegree;
import com.kingdee.bos.rpc.healthdegree.HealthDegree;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.impl.ServiceDispatcher;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalance;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalanceLocalizer;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class TCPServer
extends Thread
implements IServer {
    static final Logger logger = Logger.getLogger(TCPServer.class);
    public static final int DEFAULT_PORT = 11034;
    public static final String DEFAULT = "default";
    private int port;
    private ServerSocket serverSocket;
    private final String redirectUrl;
    protected LoadBalanceLocalizer lbl;
    protected String serverName = "default";
    private ServiceDispatcher dispatcher;
    private HashMap sessions;
    protected IHealthDegree hd;
    private boolean standby;
    protected long interval = 8000L;
    protected PerformanceValue oom;
    private volatile String ip = null;
    private volatile Set<String> allIpsMap = new HashSet<String>();

    public TCPServer(LoadBalanceLocalizer lbl, String serverName, int port) throws IOException {
        this(serverName, port, null);
        this.lbl = lbl;
    }

    public TCPServer(ServerSocket serverSocket, String redirectUrl) {
        this("TCPServer", serverSocket, redirectUrl);
    }

    protected TCPServer(String serverName, ServerSocket serverSocket, String redirectUrl) {
        super("RPC-" + serverName + "(" + serverSocket.getLocalPort() + ")");
        this.setDaemon(true);
        this.serverSocket = serverSocket;
        this.redirectUrl = redirectUrl;
        this.serverName = serverName;
        IHealthDegree ihd = ServerManager.getConfig((String)serverName).healthDegree;
        if (ihd == null) {
            ihd = new BaseHealthDegree();
        }
        this.hd = ihd;
        ServerManager.registerServer(this);
    }

    public TCPServer(String serverName, int port, String redirectUrl) throws IOException {
        super("RPC-" + serverName + "(" + port + ")");
        this.setDaemon(true);
        this.port = port;
        this.redirectUrl = redirectUrl;
        this.serverName = serverName;
        IHealthDegree ihd = ServerManager.getConfig((String)serverName).healthDegree;
        if (ihd == null) {
            ihd = new BaseHealthDegree();
        }
        this.hd = ihd;
        this.standby = ServerManager.getConfig((String)serverName).standby;
        if (!this.standby) {
            try {
                this.serverSocket = this.createServerSocket(port);
            }
            catch (Exception e) {
                if (e instanceof BindException) {
                    logger.error((Object)(port + " port already in use!"));
                    throw (IOException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                logger.error((Object)"Server socket create error.", (Throwable)e);
            }
        }
        if (this.serverSocket != null) {
            ServerManager.registerServer(this);
        }
    }

    public TCPServer(ServerSocket serverSocket) {
        this(serverSocket, null);
    }

    public TCPServer(int port, String redirectUrl) throws IOException {
        this(DEFAULT, port, redirectUrl);
    }

    public TCPServer(int port) throws IOException {
        this(port, null);
    }

    public TCPServer(String redirectUrl) throws IOException {
        this(11034, redirectUrl);
    }

    public TCPServer() throws IOException {
        this(11034);
    }

    public TCPServer(String serverName, int port) throws IOException {
        this(serverName, port, null);
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.hd != null) {
            ((HealthDegree)this.hd).startSample();
            this.oom = new PerformanceValue(this.getName() + ":oom"){

                @Override
                public Object value() {
                    return new Boolean(((HealthDegree)TCPServer.this.hd).isOom());
                }
            };
            PerformanceManager.setValue(this.oom);
        }
    }

    @Override
    public void shutdown() {
        IOUtil.close(this.serverSocket);
        this.serverSocket = null;
        if (this.sessions != null) {
            Map clone = (Map)this.sessions.clone();
            for (RPCServerSession session : clone.values()) {
                session.close();
            }
        }
        if (this.dispatcher != null) {
            this.dispatcher.shutdown();
            this.dispatcher = null;
        }
        if (this.oom != null) {
            PerformanceManager.removeValue(this.oom);
        }
        if (this.serverName.startsWith("loadbalance")) {
            LoadBalance.working = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.standby) {
            logger.info((Object)(this.getName() + " standby."));
            boolean first = true;
            while (true) {
                try {
                    Socket sock = new Socket(InetAddress.getByName(null), this.port);
                    if (first) {
                        logger.warn((Object)("port " + this.port + " already in use!"));
                        first = false;
                    }
                    IOUtil.close(sock);
                }
                catch (UnknownHostException e) {
                    logger.error((Object)"standby socket create error.", (Throwable)e);
                }
                catch (IOException e1) {
                    try {
                        this.serverSocket = this.createServerSocket(this.port);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"terminate loop create socket.", (Throwable)e);
                    break;
                }
            }
        }
        if (this.serverSocket == null) {
            return;
        }
        logger.info((Object)(this.getName() + " start."));
        if (this.serverName.startsWith("loadbalance")) {
            LoadBalance.working = true;
        }
        try {
            try {
                while (true) {
                    Socket sock = this.serverSocket.accept();
                    RPCEngine.startThread(new Connection(sock, this));
                }
            }
            catch (Throwable _) {
                logger.error((Object)(this.getName() + " accept error ,will shutdown"), _);
                this.shutdown();
            }
        }
        catch (Throwable throwable) {
            this.shutdown();
            throw throwable;
        }
    }

    protected ServerSocket createServerSocket(int port) throws Exception {
        ServerSocket ss = null;
        if (ServerManager.getConfig((String)this.serverName).reuseAddress == null) {
            ss = new ServerSocket(port);
        } else {
            ss = new ServerSocket();
            ss.setReuseAddress(ServerManager.getConfig((String)this.serverName).reuseAddress);
            InetSocketAddress endpoint = new InetSocketAddress(port);
            ss.bind(endpoint);
        }
        return ss;
    }

    @Override
    public RPCConfig getConfig() {
        ServerManager.setCurrentServer(this.serverName);
        RPCConfig config = ServerManager.getConfig();
        ServerManager.setCurrentServer(null);
        return config;
    }

    @Override
    public boolean hasStandby() {
        return this.standby;
    }

    @Override
    public ServiceDispatcher getServiceDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new ServiceDispatcher(this.serverName);
        }
        return this.dispatcher;
    }

    @Override
    public Map getSessions() {
        if (this.sessions == null) {
            this.sessions = PerformanceManager.createHashMap(this.serverName + "." + "ServerSession.count");
        }
        return this.sessions;
    }

    @Override
    public Map statistics() {
        return null;
    }

    public IHealthDegree getIHealthDegree() {
        return this.hd;
    }

    @Override
    public Map getHealthDegree() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mbeanName = new ObjectName("jmxBean:name=HeathReport");
            Map sjson = (Map)server.getAttribute(mbeanName, "HeathReport");
            return sjson;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    @Override
    public boolean match(String url) {
        Set<String> set = this.getAllIPS();
        if (this.ip == null) {
            try {
                this.ip = InetAddress.getLocalHost().getHostAddress();
                if (!set.contains(this.ip)) {
                    set.add(this.ip);
                }
            }
            catch (UnknownHostException e) {
                this.ip = this.serverSocket.getInetAddress().getHostAddress();
                logger.error((Object)("UnknownHostException:" + TCPServer.class.getName()), (Throwable)e);
            }
        }
        int port = this.serverSocket.getLocalPort();
        int index = url.indexOf("//");
        String ip2 = null;
        ip2 = index < 0 ? url.substring(0, url.lastIndexOf(":")) : url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
        String temp = url.substring(url.lastIndexOf(":") + 1);
        int port2 = Integer.parseInt(temp);
        if ("0.0.0.0".equals(this.ip) || "localhost".equalsIgnoreCase(ip2) || "127.0.0.1".equals(ip2)) {
            return port == port2;
        }
        return port == port2 && set.contains(ip2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllIPS() {
        if (this.allIpsMap.size() > 0) {
            return this.allIpsMap;
        }
        Set<String> set = this.allIpsMap;
        synchronized (set) {
            if (this.allIpsMap.size() > 0) {
                return this.allIpsMap;
            }
            HashSet<String> set2 = new HashSet<String>();
            try {
                InetAddress[] adds;
                String hostName = InetAddress.getLocalHost().getHostName();
                for (InetAddress add : adds = InetAddress.getAllByName(hostName)) {
                    set2.add(add.getHostAddress());
                }
                Enumeration<NetworkInterface> ee = NetworkInterface.getNetworkInterfaces();
                while (ee.hasMoreElements()) {
                    NetworkInterface netInt = ee.nextElement();
                    List<InterfaceAddress> kk = netInt.getInterfaceAddresses();
                    for (int i = 0; i < kk.size(); ++i) {
                        InterfaceAddress addr2 = kk.get(i);
                        if (!(addr2.getAddress() instanceof Inet4Address)) continue;
                        String aip = addr2.getAddress().toString();
                        if (aip != null && aip.startsWith("/")) {
                            aip = aip.substring(1, aip.length());
                        }
                        set2.add(aip);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.allIpsMap.addAll(set2);
        }
        return this.allIpsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIpsSet() {
        Set<String> set = this.allIpsMap;
        synchronized (set) {
            this.allIpsMap.clear();
        }
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    static {
        RPCEngine.class.getClass();
    }

    private class Connection
    implements Runnable {
        Socket sock;
        TCPServer server;

        Connection(Socket sock, TCPServer server) {
            this.sock = sock;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServerManager.setCurrentServer(TCPServer.this.serverName);
                RPCConnection conn = new RPCConnection(this.server);
                conn.clientInetAddress = this.sock.getInetAddress();
                conn.clientIp = this.sock.getInetAddress().toString();
                conn.serverIp = this.sock.getLocalAddress().getHostAddress();
                if (TCPServer.this.lbl != null) {
                    conn.setLbl(TCPServer.this.lbl);
                }
                conn.accept(TCPServer.this.getName(), this.sock, TCPServer.this.redirectUrl);
            }
            catch (Throwable e) {
                IOUtil.close(this.sock);
                IOUtil.logIOError(logger, e);
            }
            finally {
                ServerManager.setCurrentServer(null);
            }
        }
    }
}

