/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.netty.ResponseFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FutureAdapter<V>
implements Future<V> {
    private final ResponseFuture future;

    public FutureAdapter(ResponseFuture future) {
        this.future = future;
    }

    public ResponseFuture getFuture() {
        return this.future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return (V)this.future.get();
        }
        catch (Throwable t) {
            throw RPCException.createIt(t);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        int timeoutInMillis = (int)TimeUnit.MILLISECONDS.convert(timeout, unit);
        try {
            return (V)this.future.get(timeoutInMillis);
        }
        catch (Throwable t) {
            throw RPCException.createIt(t);
        }
    }
}

