/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty;

import com.kingdee.bos.rpc.impl.InvokeResult;
import com.kingdee.bos.rpc.impl.RPCInvoke;
import com.kingdee.bos.rpc.io.IOManager;
import com.kingdee.bos.rpc.io.InvokeHelper;
import com.kingdee.bos.rpc.netty.NettyInvokeHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;

public class Response {
    public static final byte OK = 20;
    public static final byte CLIENT_TIMEOUT = 30;
    public static final byte SERVER_TIMEOUT = 31;
    public static final byte BAD_REQUEST = 40;
    public static final byte BAD_RESPONSE = 50;
    public static final byte SERVICE_NOT_FOUND = 60;
    public static final byte SERVICE_ERROR = 70;
    public static final byte SERVER_ERROR = 80;
    public static final byte CLIENT_ERROR = 90;
    private long id = 0L;
    private byte status = (byte)20;
    private final ByteBuf resp;
    private final RPCInvoke rpcInvoke;
    private Throwable errorMsg;
    private Object result;

    public Response(ByteBuf resp, RPCInvoke rpcInvoke, boolean isNeedConverted) {
        this.resp = resp;
        this.rpcInvoke = rpcInvoke;
        this.init(isNeedConverted);
    }

    public Response(long id, ByteBuf resp, RPCInvoke rpcInvoke, boolean isNeedConverted) {
        this(resp, rpcInvoke, isNeedConverted);
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public Throwable getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(Throwable errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public ByteBuf getResp() {
        return this.resp;
    }

    private void init(boolean isNeedConverted) {
        if (!isNeedConverted) {
            return;
        }
        try {
            InvokeResult ir = this.handleResult();
            if (ir.type == 1) {
                this.setStatus((byte)90);
                this.errorMsg = (Throwable)ir.value;
            } else {
                this.result = ir.value;
                this.setStatus((byte)20);
            }
        }
        catch (Throwable e) {
            this.setStatus((byte)90);
            this.errorMsg = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized InvokeResult handleResult() throws Throwable {
        InputStream in = null;
        try {
            InvokeResult ir;
            in = new ByteBufInputStream(this.resp, true);
            if (in.available() == 0) {
                throw new IllegalStateException("future only ");
            }
            NettyInvokeHelper helper = new NettyInvokeHelper(null, in, null, false);
            InvokeHelper invokeHelper = IOManager.createInvokeHelper(null, helper, false);
            InvokeResult invokeResult = ir = this.rpcInvoke._finishInvoke(invokeHelper.getInputStream());
            return invokeResult;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public String toString() {
        return "Response [id=" + this.id + ", status=" + this.status + ", error=" + this.errorMsg + ", result=" + (this.result == this ? "this" : this.result) + "]";
    }
}

