/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty.handler;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.server.NettyServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.netty.NettyPooledTCPConnection;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.netty.RpcNettyMsgHead;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public abstract class AbstractRpcServiceHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = Logger.getLogger(AbstractRpcServiceHandler.class);
    protected NettyServer server;
    protected NettyPooledTCPConnection cn = null;
    private volatile boolean isInited;

    public AbstractRpcServiceHandler(NettyServer server) {
        this.server = server;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        ServerManager.setCurrentServer(this.server.getName());
        try {
            if (!this.isInited) {
                this.initConnection(ctx, byteBuf);
            } else {
                this.handlerMsg(ctx, byteBuf);
            }
        }
        catch (Exception e) {
            logger.error((Object)"rpc error", (Throwable)e);
            throw RPCException.createIt(e);
        }
        finally {
            ServerManager.setCurrentServer(null);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)"rpc netty error", cause);
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            ctx.close();
        }
    }

    protected void initConnection(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        Channel channel = ctx.channel();
        ByteBuf byteBufOut = null;
        ByteBufInputStream in = new ByteBufInputStream(byteBuf, true);
        ByteBufOutputStream out = null;
        try {
            RpcNettyMsgHead msgHead = RpcNettyMsgHead.readFromByteBuf(byteBuf);
            long randomId = msgHead.getMsgId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rpcservice channelRead receive. randomId is " + randomId));
            }
            byteBufOut = msgHead.writeToByteBuf();
            out = new ByteBufOutputStream(byteBufOut);
            this.cn = this.initRpcContext(channel, (InputStream)in, (OutputStream)out);
            channel.write((Object)out.buffer());
            if (this.cn != null && this.cn.getRedirect() != null) {
                this.handleRedirect(channel, this.cn.getRedirect());
            } else {
                channel.writeAndFlush((Object)RpcNettyConstant.getDelimiterByByteBuf());
            }
            if (this.cn != null) {
                this.isInited = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"rpc initConnection error", (Throwable)e);
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NettyPooledTCPConnection initRpcContext(Channel channel, InputStream in, OutputStream out) throws Exception {
        RPCConnection conn = new RPCConnection(this.server);
        conn.clientInetAddress = ((InetSocketAddress)channel.remoteAddress()).getAddress();
        conn.clientIp = conn.clientInetAddress.toString();
        conn.serverIp = ((InetSocketAddress)channel.localAddress()).getAddress().getHostAddress();
        NettyPooledTCPConnection cn = null;
        try {
            ConnectionHelper redirect = conn.accept(in, out, this.server.getRedirectUrl(), this.server.getName());
            cn = new NettyPooledTCPConnection(conn.url, conn.props, false);
            cn.setRedirect(redirect);
            cn.setCounter("Connection.server.count", this.server.getName());
            cn.setServer(this.server);
        }
        catch (RPCIOException e) {
            logger.warn((Object)("rpc netty initRpcContext error. channel is " + conn.clientInetAddress), (Throwable)e);
        }
        return cn;
    }

    protected void handleRedirect(Channel channel, ConnectionHelper redirect) throws Exception {
    }

    public abstract void handlerMsg(ChannelHandlerContext var1, ByteBuf var2) throws Exception;
}

