/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty.handler;

import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.netty.handler.RpcClientIdleHandler;
import com.kingdee.bos.rpc.netty.handler.RpcInvokeHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class NettyChannelPoolHandler
implements ChannelPoolHandler {
    static final Logger logger = Logger.getLogger(NettyChannelPoolHandler.class);

    public void channelReleased(Channel ch2) throws Exception {
    }

    public void channelAcquired(Channel ch2) throws Exception {
    }

    public void channelCreated(Channel ch2) throws Exception {
        SocketChannel channel = (SocketChannel)ch2;
        this.basicConfig((Channel)channel);
        this.handlerConfig((Channel)channel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("channel created and channel id is " + ch2.id()));
        }
    }

    private void handlerConfig(Channel ch2) {
        long testInterval = ServerManager.getConfig().pooledSocketTestIntervalTime;
        ch2.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, RpcNettyConstant.getDelimiterByByteBuf())});
        ch2.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, testInterval, TimeUnit.SECONDS));
        ch2.pipeline().addLast("RpcClientIdleHandler", (ChannelHandler)new RpcClientIdleHandler());
        ch2.pipeline().addLast("channelHandler", (ChannelHandler)new RpcInvokeHandler());
    }

    private void basicConfig(Channel ch2) {
        SocketChannel channel = (SocketChannel)ch2;
        channel.config().setKeepAlive(true);
        channel.config().setTcpNoDelay(true);
    }
}

