/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.netty.handler;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.ConnectionHelper;
import com.kingdee.bos.rpc.io.driver.RPCConnection;
import com.kingdee.bos.rpc.io.server.NettyServer;
import com.kingdee.bos.rpc.netty.NettyChannelPool;
import com.kingdee.bos.rpc.netty.RpcNettyConstant;
import com.kingdee.bos.rpc.netty.handler.AbstractRpcServiceHandler;
import com.kingdee.bos.rpc.netty.handler.RpcInvokeHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class RpcClusterServiceHandler
extends AbstractRpcServiceHandler {
    protected ChannelFuture connectFuture = null;

    public RpcClusterServiceHandler(NettyServer server) {
        super(server);
    }

    @Override
    public void handlerMsg(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        ConnectionHelper redirect = this.cn.getRedirect();
        if (redirect == null) {
            throw new IllegalStateException("RpcClusterServiceHandler only handle requests that point to cluster controller");
        }
        if (this.connectFuture != null && this.connectFuture.isDone()) {
            this.connectFuture.channel().write((Object)byteBuf);
            this.connectFuture.channel().writeAndFlush((Object)RpcNettyConstant.getDelimiterByByteBuf());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cc proxy send message to server, channelID is " + this.connectFuture.channel().id() + " cahnnel " + this.connectFuture.channel().remoteAddress()));
            }
        } else {
            throw new RuntimeException("cc proxy connectFuture error connectFuture is illegality " + redirect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRedirect(final Channel channel, final ConnectionHelper redirect) throws Exception {
        InetSocketAddress address = RPCConnection.getAddress(redirect.getConnectionUrl(), 11034);
        if (this.connectFuture == null || !this.connectFuture.isSuccess()) {
            RpcClusterServiceHandler rpcClusterServiceHandler = this;
            synchronized (rpcClusterServiceHandler) {
                if (this.connectFuture == null || !this.connectFuture.isSuccess()) {
                    Bootstrap bootstrap = new Bootstrap();
                    final RedirectInboundHandler rih = new RedirectInboundHandler(channel);
                    ((Bootstrap)bootstrap.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        protected void initChannel(SocketChannel ch2) throws Exception {
                            ch2.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(Integer.MAX_VALUE, RpcNettyConstant.getDelimiterByByteBuf())});
                            ch2.pipeline().addLast(new ChannelHandler[]{new RpcInvokeHandler()});
                        }
                    });
                    bootstrap.group((EventLoopGroup)channel.eventLoop());
                    this.connectFuture = bootstrap.connect((SocketAddress)address);
                    this.connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            final Channel ch2 = future.channel();
                            if (future.isSuccess() && ch2.isActive()) {
                                RPCEngine.startThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        block3: {
                                            try {
                                                if (!ch2.isActive()) {
                                                    throw new RuntimeException("future.channel().is not active");
                                                }
                                                this.handleProxyConnection(redirect, rih, ch2);
                                            }
                                            catch (Exception e) {
                                                AbstractRpcServiceHandler.logger.error((Object)("Server fail bind to " + ch2.remoteAddress()), (Throwable)e);
                                                if (!channel.isActive()) break block3;
                                                channel.close();
                                            }
                                        }
                                    }
                                });
                            } else {
                                AbstractRpcServiceHandler.logger.error((Object)("Server fail bind to " + future.channel().remoteAddress()), future.cause());
                                if (channel.isActive()) {
                                    channel.close();
                                }
                                RPCException.createIt(future.cause());
                            }
                        }

                        private void handleProxyConnection(ConnectionHelper redirect2, ChannelInboundHandlerAdapter cih, Channel ch2) throws Exception {
                            NettyChannelPool.INS.connect(ch2, redirect2.getConnectionUrl(), redirect2.getConnectionProps());
                            ch2.pipeline().remove(RpcInvokeHandler.class);
                            ch2.pipeline().addLast(new ChannelHandler[]{cih});
                            channel.writeAndFlush((Object)RpcNettyConstant.getDelimiterByByteBuf());
                        }
                    });
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("current thread is + " + Thread.currentThread().getName() + " and address is " + address));
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.connectFuture != null) {
            this.connectFuture.channel().close();
        }
    }

    class RedirectInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final Channel outChannel;

        public RedirectInboundHandler(Channel outChannel) {
            this.outChannel = outChannel;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf byteBuf = (ByteBuf)msg;
            if (!this.outChannel.isActive()) {
                AbstractRpcServiceHandler.logger.error((Object)("outChannel is not active !" + this.outChannel));
            }
            this.outChannel.write((Object)byteBuf);
            this.outChannel.writeAndFlush((Object)RpcNettyConstant.getDelimiterByByteBuf());
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (AbstractRpcServiceHandler.logger.isDebugEnabled()) {
                AbstractRpcServiceHandler.logger.debug((Object)("cc proxy connect success and channel is " + ctx.channel().remoteAddress()));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            AbstractRpcServiceHandler.logger.error((Object)"cc proxy error", cause);
            if (ctx.channel().isActive()) {
                ctx.close();
            }
            if (RpcClusterServiceHandler.this.connectFuture != null && RpcClusterServiceHandler.this.connectFuture.channel().isActive()) {
                RpcClusterServiceHandler.this.connectFuture.channel().close();
            }
            this.outChannel.close();
        }
    }
}

