/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.performance;

import com.kingdee.bos.rpc.performance.LongValue;

public class CounterValue
extends LongValue {
    protected long lastTime = 0L;
    protected LongValue parent;

    CounterValue(String name, LongValue parent) {
        super(name, 0L);
        this.parent = parent;
    }

    @Override
    public Object value() {
        return this.getCountPer();
    }

    public long getTotalCount() {
        return this.parent.getValue();
    }

    public synchronized long getCountPer() {
        if (this.lastTime == 0L) {
            return 0L;
        }
        long curTime = System.currentTimeMillis();
        if (this.lastTime == curTime) {
            return 0L;
        }
        long ave = this.value * 60L * 1000L / (curTime - this.lastTime);
        if (curTime - this.lastTime >= 60000L) {
            this.value = 0L;
            this.lastTime = curTime;
        }
        return ave;
    }

    public void append() {
        this.append(1L);
    }

    @Override
    public synchronized void append(long append) {
        if (this.lastTime == 0L) {
            this.lastTime = System.currentTimeMillis();
        }
        if (this.parent != null) {
            this.parent.append(append);
        }
        this.value += append;
    }
}

