/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.performance;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.impl.GenerateMethod;
import com.kingdee.bos.rpc.impl.RPCCommand;
import com.kingdee.bos.rpc.impl.ThreadContext;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import java.lang.reflect.Method;

public class InvokeRecord
extends RPCCommand {
    public String url;
    public int side;
    public int command = 0;
    public long startRequestTime = 0L;
    public long finishRequestTime = 0L;
    public long startResponseTime = 0L;
    public long finishResponseTime = 0L;
    public long requestBytes = 0L;
    public long requestAcutalBytes = 0L;
    public long responseBytes = 0L;
    public long responseActualBytes = 0L;
    public Detail detail = null;
    public Object err = null;
    private static final ThreadContext threadRecords = new ThreadContext();
    public static final int ALL = 3;
    public static final int ACTUAL = 2;
    public static final int NORMAL = 1;

    public InvokeRecord(int side, String url) {
        this.side = side;
        this.url = url;
    }

    public String toString() {
        return "[" + PerformanceManager.formatTime(this.startRequestTime) + "]" + "[Thread(" + Thread.currentThread().getName() + ")]" + "[" + InvokeRecord.sideName(this.side) + "]" + "[" + InvokeRecord.commandName(this.command) + "]" + "[request: " + this.requestBytes + " byte(s), actual=" + this.requestAcutalBytes + "]" + "[response: " + this.responseBytes + " byte(s), actual=" + this.responseActualBytes + "]" + "[time=" + this.getTime() + ", request=" + this.getRequestTime() + ", invoke=" + this.getInvokeTime() + ", response=" + this.getResponseTime() + "]" + (this.err == null ? "" : "[Error=" + this.err.toString() + "]") + (this.detail == null ? "" : this.detail.toString());
    }

    public long getTime() {
        return this.finishResponseTime - this.startRequestTime;
    }

    public long getRequestTime() {
        return this.finishRequestTime - this.startRequestTime;
    }

    public long getResponseTime() {
        return this.finishResponseTime - this.startResponseTime;
    }

    public long getInvokeTime() {
        return this.startResponseTime - this.finishRequestTime;
    }

    public void finishInvoke() {
        this.finishResponseTime = System.currentTimeMillis();
        if (this.startResponseTime == 0L) {
            this.startResponseTime = this.finishResponseTime;
        }
        if (this.finishRequestTime == 0L) {
            this.finishRequestTime = this.startResponseTime;
        }
        if (this.startRequestTime == 0L) {
            this.startRequestTime = this.finishRequestTime;
        }
    }

    public void setCommand(int command) {
        this.command = command;
        switch (command) {
            case 1: {
                this.detail = new CreateSession();
                break;
            }
            case 2: {
                this.detail = new CloseSession();
                break;
            }
            case 3: {
                this.detail = new CreateObject();
                break;
            }
            case 4: {
                this.detail = new ReleaseObject();
                break;
            }
            case 20: {
                this.detail = new MethodInvoke();
                break;
            }
            case 0: {
                this.detail = new MethodInvoke();
                break;
            }
            case 5: {
                this.detail = new GetError();
                break;
            }
            case 6: {
                this.detail = new GetModel();
                break;
            }
            case 9: {
                this.detail = new Ping();
                break;
            }
            case 7: {
                this.detail = new KeepAlive();
            }
        }
    }

    private static String ids(long[] ids) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ids[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static String model(Class model) {
        if (model == null) {
            return "null";
        }
        return model.getName();
    }

    public static boolean recordClient() {
        InvokeMonitor[] ivms = RPCConfig.invokeMonitors;
        for (int i = 0; i < ivms.length; ++i) {
            if (ivms[i] == null || !ivms[i].recordClient) continue;
            return true;
        }
        return false;
    }

    public static boolean recordServer() {
        InvokeMonitor[] ivms = RPCConfig.invokeMonitors;
        for (int i = 0; i < ivms.length; ++i) {
            if (ivms[i] == null || !ivms[i].recordServer) continue;
            return true;
        }
        return false;
    }

    public static InvokeRecord createServer(String url) {
        if (InvokeRecord.recordServer()) {
            return new InvokeRecord(1, url);
        }
        return null;
    }

    public static InvokeRecord createClient(int command, String url) {
        if (InvokeRecord.recordClient()) {
            InvokeRecord rec = new InvokeRecord(0, url);
            rec.setCommand(command);
            return rec;
        }
        return null;
    }

    public static InvokeRecord getCurrent() {
        return (InvokeRecord)threadRecords.get();
    }

    public static InvokeRecord setCurrent(InvokeRecord rec) {
        return (InvokeRecord)threadRecords.set(rec);
    }

    public boolean isServer() {
        return this.side == 1;
    }

    public boolean isClient() {
        return this.side == 0;
    }

    public void doInput(int bytes, int type) {
        if (this.isClient()) {
            if (this.startResponseTime == 0L) {
                this.startResponseTime = System.currentTimeMillis();
            }
            if (bytes > 0) {
                if ((type & 1) != 0) {
                    this.responseBytes += (long)bytes;
                }
                if ((type & 2) != 0) {
                    this.responseActualBytes += (long)bytes;
                }
            }
        } else {
            if (this.startRequestTime == 0L) {
                this.startRequestTime = System.currentTimeMillis();
            }
            if (bytes > 0) {
                if ((type & 1) != 0) {
                    this.requestBytes += (long)bytes;
                }
                if ((type & 2) != 0) {
                    this.requestAcutalBytes += (long)bytes;
                }
            }
        }
    }

    public void doOutput(int bytes, int type) {
        if (this.isServer()) {
            if ((type & 1) != 0) {
                this.responseBytes += (long)bytes;
            }
            if ((type & 2) != 0) {
                this.responseActualBytes += (long)bytes;
            }
        } else {
            if ((type & 1) != 0) {
                this.requestBytes += (long)bytes;
            }
            if ((type & 2) != 0) {
                this.requestAcutalBytes += (long)bytes;
            }
        }
    }

    public static class MethodInvoke
    extends ObjectDetail {
        public String transactionName;
        public String transactionId;
        public String user;
        public int invokeId = 0;
        public Class model = null;
        public int methodCode;
        public Method method = null;
        public String repository = null;
        public Object[] args = null;
        public Object result = null;

        @Override
        public String toString() {
            return super.toString() + ", model=" + InvokeRecord.model(this.model) + ", method=" + GenerateMethod.methodName(this.method);
        }
    }

    public static class Ping
    extends Detail {
        public byte[] request = null;
        public byte[] response = null;
    }

    public static class GetError
    extends ObjectDetail {
        public int invokeId = 0;
        public Throwable result = null;

        @Override
        public String toString() {
            return super.toString() + ", invokeId=" + this.invokeId + ", result=" + this.result;
        }
    }

    public static class GetModel
    extends ObjectDetail {
        public Class model = null;
        public long newObjectId = 0L;

        @Override
        public String toString() {
            return super.toString() + ", model=" + InvokeRecord.model(this.model) + ", newObjectId=" + this.newObjectId;
        }
    }

    public static class ReleaseObject
    extends SessionDetail {
        public long[] objectIds = null;

        @Override
        public String toString() {
            return super.toString() + ", objects=" + InvokeRecord.ids(this.objectIds);
        }
    }

    public static class CreateObject
    extends ObjectDetail {
        public String name = null;
        public Class model = null;
        public Class[] argTypes = null;
        public Object[] args = null;
        public String transactionName;
        public String transactionId;
        public String user;

        @Override
        public String toString() {
            return super.toString() + ", name=" + this.name + ", model=" + InvokeRecord.model(this.model) + GenerateMethod.parametersName(this.argTypes);
        }
    }

    public static class KeepAlive
    extends SessionDetail {
    }

    public static class CloseSession
    extends Detail {
        public long[] sessions = null;
    }

    public static class CreateSession
    extends SessionDetail {
    }

    public static abstract class ObjectDetail
    extends SessionDetail {
        public long objectId = 0L;

        @Override
        public String toString() {
            return super.toString() + " ,object=" + this.objectId;
        }
    }

    public static abstract class SessionDetail
    extends Detail {
        public long sessionId = 0L;

        public String toString() {
            return "session=" + this.sessionId;
        }
    }

    public static abstract class Detail {
    }
}

