/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.performance.ui;

import com.kingdee.bos.rpc.io.Connector;
import com.kingdee.bos.rpc.io.DefaultConnectionMonitor;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.performance.PerformanceManager;
import com.kingdee.bos.rpc.performance.PerformanceValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class PerformancePanel
extends JPanel
implements Runnable {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    DefaultTableModel model = new DefaultTableModel(new String[]{"name", "value"}, 0);
    JTable table = new JTable(this.model);
    private static final NumberFormat nf = new DecimalFormat("#,###,##0");
    private static JFrame frm = null;
    private static boolean paused = false;
    private static final Object pauseMonitor = new Object();

    public PerformancePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Thread t = new Thread((Runnable)this, "PerformanceViewer");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                for (int i = 0; i < 10; ++i) {
                    this.refresh();
                    Thread.sleep(1000L);
                }
                try {
                    System.gc();
                }
                catch (Throwable _) {}
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private Object format(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return nf.format(value);
        }
        return value;
    }

    public void refresh() {
        Object[] values = PerformanceManager.getValues();
        Arrays.sort(values);
        if (this.model.getRowCount() != values.length) {
            this.model.setRowCount(values.length);
        }
        for (int i = 0; i < values.length; ++i) {
            String name = ((PerformanceValue)values[i]).name();
            Object value = this.format(((PerformanceValue)values[i]).value());
            Object v = this.model.getValueAt(i, 0);
            if (v == null || !v.equals(name)) {
                this.model.setValueAt(name, i, 0);
            }
            if ((v = this.model.getValueAt(i, 1)) != null && v.equals(value)) continue;
            this.model.setValueAt(value, i, 1);
        }
        this.model.fireTableDataChanged();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add(this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPaused() {
        Object object = pauseMonitor;
        synchronized (object) {
            return paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPause() {
        Object object = pauseMonitor;
        synchronized (object) {
            while (paused) {
                try {
                    pauseMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean pause() {
        Object object = pauseMonitor;
        synchronized (object) {
            boolean bl = paused = !paused;
            if (!paused) {
                pauseMonitor.notifyAll();
            }
            return paused;
        }
    }

    public static void showFrame(String appName) {
        if (frm == null) {
            frm = new JFrame(appName + " - RPC Performance Viewer");
            frm.setSize(400, 500);
            frm.getContentPane().setLayout(new BorderLayout());
            frm.getContentPane().add((Component)new PerformancePanel(), "Center");
            frm.setDefaultCloseOperation(0);
            JPanel header = new JPanel(new FlowLayout(0));
            JButton btnPause = new JButton("Pause");
            btnPause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton btnPause = (JButton)e.getSource();
                    if (PerformancePanel.pause()) {
                        btnPause.setText("Resume");
                    } else {
                        btnPause.setText("Pause");
                    }
                }
            });
            header.add(btnPause);
            JButton btnGC = new JButton("run GC");
            btnGC.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.gc();
                }
            });
            header.add(btnGC);
            JButton btnExit = new JButton("Exit");
            btnExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            header.add(btnExit);
            frm.getContentPane().add((Component)header, "North");
            ServerManager.getConfig().connectionMonitor = new DefaultConnectionMonitor(ServerManager.getConfig().connectionMonitor){

                @Override
                public void beforeConnect(Connector cn) throws IOException {
                    PerformancePanel.checkPause();
                    super.beforeConnect(cn);
                }

                @Override
                public void beforeInvoke(Connector cn) {
                    PerformancePanel.checkPause();
                    super.beforeInvoke(cn);
                }

                @Override
                public synchronized boolean retryConnect(Connector cn, IOException err, int retryTime) {
                    return JOptionPane.showConfirmDialog(frm, err.toString() + "\r\nretry connect?", cn.url, 0) == 0;
                }
            };
        }
        frm.show();
    }
}

