/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.ssl;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.ssl.TestKeyStoreProvider;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;

public abstract class SSLSecurityProivder {
    private static final Logger logger = Logger.getLogger(SSLSecurityProivder.class);

    public static SSLSecurityProivder getRPCSSLSecurityProivder() {
        String providerName = ServerManager.getConfig().defaultSSLSecurityProivder;
        if (providerName != null) {
            try {
                SSLSecurityProivder provider = SSLSecurityProivder.createProivder(providerName);
                return provider;
            }
            catch (Exception e) {
                logger.error((Object)("SSLSecurityProivder " + providerName + " cannot load"), (Throwable)e);
            }
        }
        return new TestKeyStoreProvider();
    }

    public abstract SSLContext getClientContext() throws RPCException;

    public abstract SSLContext getServerContext() throws RPCException;

    private static SSLSecurityProivder createProivder(String className) throws Exception {
        Class<?> providerNameClass = Class.forName(className, true, SSLSecurityProivder.class.getClassLoader());
        Object proivder = providerNameClass.newInstance();
        if (proivder instanceof SSLSecurityProivder) {
            return (SSLSecurityProivder)proivder;
        }
        throw new Exception("class " + className + " is not SSLSecurityProivder");
    }
}

