/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.ssl;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.ssl.SSLSecurityProivder;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class TestKeyStoreProvider
extends SSLSecurityProivder {
    private static final Logger logger = Logger.getLogger(TestKeyStoreProvider.class);
    public String sslKeyStoreFile = "TestSSLKey";
    public String sslKeyStorePassword = "12345678";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSSLContext() throws RPCException {
        KeyStore ks = null;
        RPCConfig conf = ServerManager.getConfig();
        char[] pwd = this.sslKeyStorePassword.toCharArray();
        try {
            ks = KeyStore.getInstance("JKS");
            InputStream in = this.getClass().getResourceAsStream(this.sslKeyStoreFile);
            if (in == null) {
                throw new RPCException(500, "Cannot found keystore file " + this.sslKeyStoreFile);
            }
            try {
                ks.load(in, pwd);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            logger.debug((Object)("keyManagerAlgorithm is " + conf.keyManagerAlgorithm));
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(conf.keyManagerAlgorithm);
            kmf.init(ks, pwd);
            logger.debug((Object)("trustManagerAlgorithm is " + conf.trustManagerAlgorithm));
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(conf.trustManagerAlgorithm);
            tmf.init(ks);
            logger.debug((Object)("sslProtocol is " + conf.sslProtocol));
            SSLContext ctx = SSLContext.getInstance(conf.sslProtocol);
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return ctx;
        }
        catch (GeneralSecurityException e) {
            throw new RPCException("SSL SecurityException", (Throwable)e);
        }
        catch (IOException e) {
            throw new RPCException("SSL Key File IOException", (Throwable)e);
        }
    }

    @Override
    public SSLContext getClientContext() throws RPCException {
        return this.getSSLContext();
    }

    @Override
    public SSLContext getServerContext() throws RPCException {
        return this.getSSLContext();
    }
}

