/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.trace;

import com.kingdee.bos.orm.core.rmi.MonitorDisableList;
import com.kingdee.bos.orm.core.rmi.RMIMonitorFactory;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpc.performance.InvokeRecord;

public class TraceInvokeMonitor
extends InvokeMonitor {
    public TraceInvokeMonitor(boolean client, boolean server) {
        super(client, server);
    }

    public TraceInvokeMonitor() {
        super(true, false);
    }

    @Override
    public void invokePerformed(InvokeRecord rec) {
        if (this.getModel(rec) == null) {
            return;
        }
        if (!MonitorDisableList.getInstance().isIgnore(this.getModel(rec))) {
            RMIMonitorFactory.getRMIMonitor().traceNewRPC(rec);
        }
    }

    public synchronized void install() {
        for (int i = 0; i < RPCConfig.invokeMonitors.length; ++i) {
            if (!(RPCConfig.invokeMonitors[i] instanceof TraceInvokeMonitor)) continue;
            return;
        }
        RPCConfig.addInvokeMonitor(this);
    }

    public synchronized void restore() {
        for (int i = 0; i < RPCConfig.invokeMonitors.length; ++i) {
            if (!(RPCConfig.invokeMonitors[i] instanceof TraceInvokeMonitor)) continue;
            RPCConfig.removeInvokeMonitor(RPCConfig.invokeMonitors[i]);
            break;
        }
    }

    Class getModel(InvokeRecord rec) {
        switch (rec.command) {
            case 0: {
                InvokeRecord.MethodInvoke mi = (InvokeRecord.MethodInvoke)rec.detail;
                return mi.model;
            }
            case 20: {
                InvokeRecord.MethodInvoke mi1 = (InvokeRecord.MethodInvoke)rec.detail;
                return mi1.model;
            }
            case 3: {
                InvokeRecord.CreateObject co = (InvokeRecord.CreateObject)rec.detail;
                try {
                    return Class.forName(co.name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

