/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.transaction;

import com.kingdee.bos.rpc.ThreadListener;
import com.kingdee.bos.rpc.ThreadListenerManager;
import com.kingdee.bos.rpc.transaction.TransactionInfo;

public class TransactionManager {
    public static ThreadLocal<TransactionInfo> tl = new ThreadLocal();
    public static TransactionInfo NULL_INFO = new TransactionInfo("UNKNOWN", null);

    public static TransactionInfo getCurrentTransactionInfo() {
        TransactionInfo info = tl.get();
        return info == null ? NULL_INFO : info;
    }

    public static void passTransaction() {
        TransactionManager.tl.get().passed = true;
    }

    public static void startTransaction(String name, String id, String userName) {
        TransactionInfo info = new TransactionInfo(name, id);
        info.user = userName;
        TransactionInfo p = tl.get();
        if (p != null) {
            info.parent = p;
        }
        tl.set(info);
    }

    public static void endTransaction() {
        TransactionInfo t = tl.get();
        tl.set(t.parent);
    }

    static {
        ThreadListenerManager.addListener(new ThreadListener(){

            @Override
            public void threadStarted(Thread thread) {
            }

            @Override
            public void threadFinished(Thread thread) {
                tl.set(null);
            }

            @Override
            public void threadRecycled(Thread thread) {
            }

            @Override
            public void threadRemoved(Thread thread) {
            }
        });
    }
}

