/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc_availability.urllist;

import com.kingdee.bos.rpc_availability.ServerListRepresent;
import com.kingdee.bos.rpc_availability.urllist.URLServerFacede;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class UrlServerListRepresent
implements ServerListRepresent {
    public static final String URL_LIST_SEPEATER = "|";
    public static final HashMap serverListRepresentCache = new HashMap();
    private static final Logger logger = Logger.getLogger(UrlServerListRepresent.class);
    private String urlList;
    List servers;

    protected UrlServerListRepresent(String urlList) {
        this.urlList = urlList;
        String[] serverUrls = StringUtils.split((String)urlList, (String)URL_LIST_SEPEATER);
        this.servers = new ArrayList(serverUrls.length);
        for (int n = serverUrls.length - 1; n >= 0; --n) {
            String url = serverUrls[n];
            if (UrlServerListRepresent.isLegalServerUrl(url)) {
                this.servers.add(new URLServerFacede(url));
                continue;
            }
            logger.error((Object)("url \"" + url + "\" is illegal,not add into server list"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerListRepresent getServerFacedeList(String urlList) {
        if (StringUtils.isEmpty((String)urlList)) {
            return null;
        }
        HashMap hashMap = serverListRepresentCache;
        synchronized (hashMap) {
            UrlServerListRepresent entry = (UrlServerListRepresent)serverListRepresentCache.get(urlList);
            if (entry == null) {
                entry = new UrlServerListRepresent(urlList);
                serverListRepresentCache.put(urlList, entry);
            }
            return entry;
        }
    }

    @Override
    public List getServerFacedeList() {
        return this.servers;
    }

    public static boolean isLegalServerUrl(String url) {
        String tmpUrl = url.toLowerCase();
        return tmpUrl.startsWith("tcp://") || tmpUrl.startsWith("tcps://") || tmpUrl.startsWith("https://") || tmpUrl.startsWith("tcp2://") || tmpUrl.startsWith("http://") || tmpUrl.startsWith("https://") || tmpUrl.startsWith("server://") || tmpUrl.equals("internal");
    }

    public static ServerListRepresent getServerList(String url) {
        return new UrlServerListRepresent(url);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UrlServerListRepresent)) {
            return false;
        }
        return this.urlList.equals(((UrlServerListRepresent)obj).urlList);
    }

    public String toString() {
        return this.urlList;
    }
}

