/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder;

import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class SerdeTool {
    public static Object loadObjectFromXML(String file) throws IOException, JDOMException {
        return SerdeTool.loadObjectFromXML(file, new Context());
    }

    public static Object loadObjectFromXML(String file, Context ctx) throws IOException, JDOMException {
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)reader);
        Element ele = doc.getRootElement();
        long t1 = System.currentTimeMillis();
        SerdeContext sctx = new SerdeContext(ctx);
        Object object = sctx.fromXML(ele);
        long t2 = System.currentTimeMillis();
        System.out.println("Cost " + (t2 - t1) + "ms.");
        return object;
    }

    public static void saveObjectAsXML(Object object, String fileName) throws IOException {
        SerdeTool.saveObjectAsXML(object, fileName, false);
    }

    public static void saveObjectAsXML(Object object, String fileName, boolean append) throws IOException {
        SerdeContext serdeContext = new SerdeContext(new Context());
        Element element = serdeContext.toXML(object);
        DefaultJDOMFactory factory = new DefaultJDOMFactory();
        Document doc = factory.document(element);
        XMLOutputter out = new XMLOutputter("  ", true);
        FileOutputStream fos = new FileOutputStream(fileName);
        out.output(doc, (OutputStream)fos);
        fos.flush();
        fos.close();
    }
}

