/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder;

import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.command.parameter.VariableParam;
import com.kingdee.bos.rpcrecorder.parametor.ParameterPair;
import com.kingdee.bos.rpcrecorder.parametor.Parametor;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class Utils {
    private static SimpleDateFormat mdf = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");

    public static void trim(String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i] == null) continue;
            ss[i] = ss[i].trim();
        }
    }

    public static String getAbsolutePath(Context ctx, String path) {
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        return path;
    }

    public static String formatSimpleTime(long time) {
        Date date = new Date(time);
        return mdf.format(date);
    }

    public static String getRPCObjectFileName(RPCRequest request) {
        String name = request.model.getName() + ".";
        String method = request.methodName;
        method = method.substring(0, method.indexOf("("));
        name = "" + Utils.formatSimpleTime(request.startTime) + "-" + name + method + ".rpc";
        name = StringUtils.replace((String)name, (String)"/", (String)".");
        return name;
    }

    public static String getRPCObjectFileNameAsXML(RPCRequest request) {
        String name = request.model.getName() + ".";
        String method = request.methodName;
        method = method.substring(0, method.indexOf("("));
        name = "" + Utils.formatSimpleTime(request.startTime) + "-" + name + method + ".xml";
        name = StringUtils.replace((String)name, (String)"/", (String)".");
        return name;
    }

    public static String replaceVariable(Context ctx, String str) {
        String ret = str;
        while (true) {
            int p1 = ret.indexOf("${");
            int p2 = ret.indexOf("}");
            if (p1 <= -1 || p2 <= p1) break;
            String b = ret.substring(0, p1);
            String v = ret.substring(p1 + 2, p2);
            String e = ret.substring(p2 + 1);
            String v2 = (String)VariableParam.getValue(ctx, v);
            if (v2 == null) {
                throw new RecorderException("Unknow Variable Name:${" + v + "}");
            }
            ret = b + v2 + e;
        }
        if (!str.equals(ret) && !Policy.isOff(ctx, Policy.POLICY_LOGRPC)) {
            System.out.println("Variable Replace " + str + " to " + ret);
        }
        return ret;
    }

    public static String replaceParameter(Context ctx, String str) {
        Iterator iter = Parametor.pairIterator(ctx);
        if (iter == null) {
            return str;
        }
        while (iter.hasNext()) {
            ParameterPair pair = (ParameterPair)iter.next();
            String str2 = StringUtils.replace((String)str, (String)pair.src, (String)pair.dest);
            if (!str.equals(str2) && !Policy.isOff(ctx, Policy.POLICY_LOGRPC)) {
                System.out.println("Paramter Replace " + str + " to " + str2);
            }
            str = str2;
        }
        return str;
    }
}

