/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command;

import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.ReplayException;
import com.kingdee.bos.rpcrecorder.command.ICommand;
import com.kingdee.bos.rpcrecorder.command.ICommandParameter;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.parameter.UnresolvedParameter;
import com.kingdee.bos.rpcrecorder.command.result.BooleanResult;
import com.kingdee.bos.rpcrecorder.command.result.ExceptionResult;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.xpath.XPath;

public class CommandGetListFromXpath
implements ICommand {
    @Override
    public String getName() {
        return "getListFromXpath";
    }

    @Override
    public ICommandResult execute(Context ctx, ICommandParameter[] parameters) {
        String p;
        UnresolvedParameter unresolvedParameter = (UnresolvedParameter)parameters[0];
        String txt = unresolvedParameter.parameter;
        int pos = txt.indexOf(",");
        if (pos < 0) {
            throw new RecorderException("Illegal command 'getListFromXpath' parameter need ','");
        }
        String v = txt.substring(0, pos);
        if (!(v = v.trim()).startsWith("$")) {
            v = "$" + v;
        }
        String r = txt.substring(pos + 1, txt.length());
        if ((r = r.trim()).startsWith("\"")) {
            p = "\"";
        } else if (r.startsWith("'")) {
            p = "'";
        } else {
            throw new RecorderException("Illegal command 'getListFromXpath' parameter need be String");
        }
        r = r.substring(1);
        pos = r.indexOf(p);
        String xpath = r.substring(0, pos);
        String attr = null;
        if (r.length() > pos + 1) {
            r = r.substring(pos + 1);
            if ((r = r.trim()).startsWith(",")) {
                r = r.substring(1);
            }
            if (r.startsWith("\"") && r.endsWith("\"")) {
                r = r.substring(1, r.length() - 1);
            } else if (r.startsWith("'") && r.endsWith("'")) {
                r = r.substring(1, r.length() - 1);
            }
            attr = r;
        }
        return this.executeXpath(ctx, v, xpath, attr);
    }

    private ICommandResult executeXpath(Context ctx, String var, String xpath, String attr) {
        RPCResult result = (RPCResult)ctx.get("_rpcresult_");
        if (result == null) {
            return new ExceptionResult(new ReplayException("Can't getresult from RPCResult, because result is null"));
        }
        if (result.isException) {
            return new ExceptionResult(new ReplayException("Can't getresult from RPCResult, because result is Exception", (Throwable)result.value));
        }
        DefaultJDOMFactory factory = new DefaultJDOMFactory();
        Element element2 = new SerdeContext(ctx).toXML(result);
        factory.document(element2);
        List list = null;
        try {
            list = XPath.selectNodes((Object)element2, (String)xpath);
            if (list == null || list.isEmpty()) {
                return new ExceptionResult(new ReplayException("Can't getresult by xpath:" + xpath));
            }
            ArrayList<String> ret = (ArrayList<String>)ctx.get(var);
            if (ret == null) {
                ret = new ArrayList<String>();
            }
            for (Element find : list) {
                String value = attr != null ? find.getAttributeValue(attr) : find.getTextNormalize();
                ret.add(value);
            }
            ctx.put(var, ret);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return new ExceptionResult(new ReplayException("Can't getresult by xpath:" + xpath, e));
        }
        return new BooleanResult(Boolean.TRUE);
    }

    @Override
    public boolean needResolveParameter() {
        return true;
    }

    @Override
    public boolean laterExecute() {
        return false;
    }
}

