/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command;

import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.IValueJudge;
import com.kingdee.bos.rpcrecorder.ResultHandlerManager;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.bos.rpcrecorder.command.ICommand;
import com.kingdee.bos.rpcrecorder.command.ICommandParameter;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.IResultHandler;
import com.kingdee.bos.rpcrecorder.command.RPCExecutor;
import com.kingdee.bos.rpcrecorder.command.result.RPCResultResult;

public class CommandRunRPC
implements ICommand {
    @Override
    public String getName() {
        return "runrpc";
    }

    @Override
    public ICommandResult execute(Context ctx, ICommandParameter[] parameters) {
        long startTime = System.currentTimeMillis();
        ctx.put("_rpcstarttime_", "" + startTime);
        String path = (String)parameters[0].getValue(ctx);
        path = Utils.getAbsolutePath(ctx, path);
        ctx.put("_rpcobjectpath_", path);
        String name = path.substring(path.lastIndexOf("/") + 1);
        ctx.put("_rpcobjectfilename_", name);
        RPCExecutor executor = new RPCExecutor(ctx, path);
        Object value = executor.execute();
        long endTime = System.currentTimeMillis();
        ctx.put("_rpcendtime_", "" + endTime);
        RPCResultResult ret = null;
        IValueJudge.Factory valueJudgeFactory = (IValueJudge.Factory)ctx.get(IValueJudge.Factory.class);
        IValueJudge vj = valueJudgeFactory.createValueJudge(value);
        RPCResult rpcresult = new RPCResult(startTime, endTime, vj.isException(), vj.getException(), vj.getValue());
        ctx.put("_rpcresult_", rpcresult);
        IResultHandler resultHandler = ResultHandlerManager.getRPCResultHandler(ctx);
        if (resultHandler != null) {
            resultHandler.handle(ctx, rpcresult);
        }
        ret = new RPCResultResult(rpcresult);
        return ret;
    }

    private Throwable handleThrowable(Throwable t) {
        if (t instanceof RPCException) {
            return t.getCause();
        }
        return t;
    }

    @Override
    public boolean needResolveParameter() {
        return false;
    }

    @Override
    public boolean laterExecute() {
        return false;
    }
}

