/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command;

import com.kingdee.bos.rpc.impl.DirectInvokeXML;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.bos.rpcrecorder.command.CommandInfo;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.IExecutor;
import com.kingdee.bos.rpcrecorder.command.LaterExecuteManager;
import com.kingdee.bos.rpcrecorder.command.RPCRequestObjectLogger;
import com.kingdee.bos.rpcrecorder.command.result.ExceptionResult;
import com.kingdee.bos.rpcrecorder.serde.GlobalCache;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class RPCExecutor
implements IExecutor {
    private Context ctx;
    private String rpcObjectPath;
    private RPCRequest rpcRequest;
    private List laterExecuteList;
    private boolean logOff;
    private static HashMap resolvedCache = new HashMap();
    private static HashMap unResolvedCache = new HashMap();

    public RPCExecutor(Context ctx, String rpcObjectPath) {
        this.rpcObjectPath = rpcObjectPath;
        this.ctx = ctx;
        this.laterExecuteList = LaterExecuteManager.getLaterExecuteList(ctx);
        this.logOff = Policy.isOff(ctx, Policy.POLICY_LOGRPC);
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    @Override
    public Object execute() {
        RPCSessionImpl session = (RPCSessionImpl)this.ctx.get("session");
        String name = this.rpcObjectPath;
        if (!this.logOff) {
            System.out.println("Starting invoke:" + name);
        }
        long t1 = System.currentTimeMillis();
        if (this.rpcRequest == null) {
            this.generateObject();
            long t2 = System.currentTimeMillis();
            String path = Utils.getAbsolutePath(this.ctx, this.rpcObjectPath);
            if (!this.logOff) {
                System.out.println("generateObject cost " + (t2 - t1) + "ms,path:" + path);
                RPCRequestObjectLogger.log(this.ctx, this.rpcRequest);
            }
        }
        DirectInvokeXML invoke = new DirectInvokeXML(this.rpcRequest, session, -20);
        Object value = invoke.invoke();
        String message = null;
        if (value == null) {
            message = "";
        } else if (value instanceof Throwable) {
            message = ((Throwable)value).getMessage();
        } else {
            message = value.getClass().getName() + ":";
            try {
                message = message + value.toString();
            }
            catch (Throwable t) {
                message = message + "Can't toString()";
            }
        }
        if (!this.logOff) {
            long t2 = System.currentTimeMillis();
            System.out.println("Invoke result:" + message);
            System.out.println("End invoke, cost " + (t2 - t1) + "ms,:" + name);
        }
        return value;
    }

    private void traceException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateObject() {
        block30: {
            String path = Utils.getAbsolutePath(this.ctx, this.rpcObjectPath);
            if (resolvedCache.containsKey(path)) {
                this.rpcRequest = (RPCRequest)resolvedCache.get(path);
                if (GlobalCache.cachedRequestPaths.contains(path)) {
                    this.laterExecuteList.clear();
                }
                return;
            }
            Element element = (Element)unResolvedCache.get(path);
            FileInputStream fis = null;
            try {
                if (element == null) {
                    String line;
                    long begin = System.currentTimeMillis();
                    fis = new FileInputStream(path);
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                    BufferedReader br = new BufferedReader(isr);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    while ((line = br.readLine()) != null) {
                        pw.println(line);
                    }
                    pw.flush();
                    sw.flush();
                    String content = sw.toString();
                    ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF-8"));
                    SAXBuilder builder = new SAXBuilder();
                    element = builder.build((InputStream)is).getRootElement();
                    if (!this.logOff) {
                        long end = System.currentTimeMillis();
                        System.out.println("parseXML cost " + (end - begin) + "ms.");
                    }
                    HashMap restoreMap = new HashMap();
                    boolean changed1 = this.replaceByLaterExecute(element, restoreMap);
                    boolean changed2 = this.replace(element, restoreMap);
                    boolean changed = changed1 || changed2;
                    boolean hasCommand = element.getAttribute("_command_") != null;
                    SerdeContext serdeContext = new SerdeContext(this.ctx);
                    if (changed1) {
                        serdeContext.setObjectChanged();
                    }
                    try {
                        begin = System.currentTimeMillis();
                        this.rpcRequest = (RPCRequest)serdeContext.fromXML(element);
                    }
                    finally {
                        this.restore(restoreMap);
                        if (!this.logOff) {
                            long end = System.currentTimeMillis();
                            System.out.println("serde xml element to object cost " + (end - begin) + "ms.");
                        }
                    }
                    if (GlobalCache.cachedRequestPaths.contains(path)) {
                        resolvedCache.put(path, this.rpcRequest);
                    } else if (changed || hasCommand || serdeContext.isObjectChanged()) {
                        unResolvedCache.put(path, element);
                    } else {
                        resolvedCache.put(path, this.rpcRequest);
                    }
                    break block30;
                }
                HashMap restoreMap = new HashMap();
                boolean changed1 = this.replaceByLaterExecute(element, restoreMap);
                boolean changed2 = this.replace(element, restoreMap);
                try {
                    SerdeContext serdeContext = new SerdeContext(this.ctx);
                    this.rpcRequest = (RPCRequest)serdeContext.fromXML(element);
                }
                finally {
                    this.restore(restoreMap);
                }
            }
            catch (FileNotFoundException e) {
                throw new RecorderException("rpc invoke parameter path not exists: " + this.rpcObjectPath);
            }
            catch (IOException e) {
                throw new RecorderException("rpc invoke parameter ojbect IOException: " + this.rpcObjectPath);
            }
            catch (JDOMException e) {
                e.printStackTrace();
                throw new RecorderException("rpc invoke parameter ojbect JDomException: " + this.rpcObjectPath + ", the message is " + e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void restore(HashMap restoreMap) {
        for (Map.Entry entry : restoreMap.entrySet()) {
            Object key = entry.getKey();
            String value = (String)entry.getValue();
            if (key instanceof Attribute) {
                ((Attribute)key).setValue(value);
                continue;
            }
            ((Text)key).setText(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceByLaterExecute(Element element, HashMap restoreMap) {
        if (this.laterExecuteList.isEmpty()) {
            return false;
        }
        long begin = System.currentTimeMillis();
        this.ctx.put("_rpcrequest_", element);
        this.ctx.put("_restoremap_", restoreMap);
        try {
            for (CommandInfo commandInfo : this.laterExecuteList) {
                ICommandResult result = commandInfo.command.execute(this.ctx, commandInfo.params);
                if (!(result instanceof ExceptionResult)) continue;
                throw (RecorderException)((ExceptionResult)result).getValue();
            }
        }
        finally {
            this.ctx.remove("_rpcrequest_");
            this.ctx.remove("_restoremap_");
            this.laterExecuteList.clear();
        }
        element.setAttribute("_hasVariable_", "true");
        if (!this.logOff) {
            long end = System.currentTimeMillis();
            System.out.println("replaceByLaterExecute cost " + (end - begin) + "ms.");
        }
        return true;
    }

    private boolean replace(Element element, HashMap restoreMap) {
        boolean changed = false;
        for (Attribute attr : element.getAttributes()) {
            String value2;
            String value = attr.getValue();
            if (value.equals(value2 = this.replace(value))) continue;
            attr.setValue(value2);
            restoreMap.put(attr, value);
            changed = true;
        }
        for (Object o : element.getChildren()) {
            if (o instanceof Text) {
                String text2;
                String text = ((Text)o).getText();
                if (text.equals(text2 = this.replace(text))) continue;
                ((Text)o).setText(text2);
                restoreMap.put(o, text);
                changed = true;
                continue;
            }
            if (o instanceof Element) {
                if (!this.replace((Element)o, restoreMap)) continue;
                changed = true;
                continue;
            }
            throw new RecorderException("\u672a\u5b9e\u73b0\u7684xml\u8282\u70b9\u7c7b\u578b\uff1a" + o.getClass());
        }
        if (changed) {
            element.setAttribute("_hasVariable_", "true");
        }
        return changed;
    }

    private String replace(String line) {
        line = Utils.replaceVariable(this.ctx, line);
        return Utils.replaceParameter(this.ctx, line);
    }

    private void parseObject() {
        String path = Utils.getAbsolutePath(this.ctx, this.rpcObjectPath);
        try {
            FileInputStream fis = new FileInputStream(path);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.rpcRequest = (RPCRequest)ois.readObject();
        }
        catch (FileNotFoundException e) {
            throw new RecorderException("rpc invoke parameter path not exists: " + this.rpcObjectPath);
        }
        catch (IOException e) {
            throw new RecorderException("rpc invoke parameter ojbect IOException: " + this.rpcObjectPath);
        }
        catch (ClassNotFoundException e) {
            throw new RecorderException("rpc invoke parameter ojbect ClassNotFoundException: " + this.rpcObjectPath);
        }
    }
}

