/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command.asserts;

import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.AssertException;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.command.ICommand;
import com.kingdee.bos.rpcrecorder.command.ICommandParameter;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.parameter.UnresolvedParameter;
import com.kingdee.bos.rpcrecorder.command.result.BooleanResult;
import com.kingdee.bos.rpcrecorder.command.result.ExceptionResult;
import com.kingdee.bos.rpcrecorder.parser.Parser;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.xpath.XPath;

public class CommandAssertGT
implements ICommand {
    @Override
    public String getName() {
        return "AssertGT";
    }

    @Override
    public ICommandResult execute(Context ctx, ICommandParameter[] parameters) {
        String p;
        if (Policy.isOff(ctx, Policy.POLICY_ENABLE_ASSERT)) {
            return new BooleanResult(Boolean.TRUE);
        }
        UnresolvedParameter unresolvedParameter = (UnresolvedParameter)parameters[0];
        String txt = unresolvedParameter.parameter;
        int pos = txt.indexOf(",");
        if (pos < 0) {
            throw new RecorderException("Illegal command 'AssertGT' parameter need ','");
        }
        String v = txt.substring(0, pos);
        v = v.trim();
        ICommandParameter para = Parser.parserParameter(v);
        Object value = para.getValue(ctx);
        String r = txt.substring(pos + 1, txt.length());
        if ((r = r.trim()).startsWith("\"")) {
            p = "\"";
        } else if (r.startsWith("'")) {
            p = "'";
        } else {
            throw new RecorderException("Illegal command 'AssertGT' parameter need be String");
        }
        r = r.substring(1);
        pos = r.indexOf(p);
        String xpath = r.substring(0, pos);
        String attr = null;
        if (r.length() > pos + 1) {
            r = r.substring(pos + 1);
            if ((r = r.trim()).startsWith(",")) {
                r = r.substring(1);
            }
            if (r.startsWith("\"") && r.endsWith("\"")) {
                r = r.substring(1, r.length() - 1);
            } else if (r.startsWith("'") && r.endsWith("'")) {
                r = r.substring(1, r.length() - 1);
            }
            attr = r;
        }
        return this.executeXpath(ctx, value, xpath, attr);
    }

    private ICommandResult executeXpath(Context ctx, Object v, String xpath, String attr) {
        RPCResult result = (RPCResult)ctx.get("_rpcresult_");
        if (result == null) {
            return new ExceptionResult(new AssertException("AssertGT false, because result is null"));
        }
        if (result.isException) {
            return new ExceptionResult(new AssertException("AssertGT false, because result is Exception"));
        }
        DefaultJDOMFactory factory = new DefaultJDOMFactory();
        Element element2 = new SerdeContext(ctx).toXML(result);
        factory.document(element2);
        Element find = null;
        try {
            find = (Element)XPath.selectSingleNode((Object)element2, (String)xpath);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return new ExceptionResult(new AssertException("AssertGT false, exception on xpath:" + xpath));
        }
        if (find == null) {
            return new ExceptionResult(new AssertException("AssertGT false, can't find xpath:" + xpath));
        }
        String value = attr != null ? find.getAttributeValue(attr) : find.getTextNormalize();
        if (value == null) {
            return new ExceptionResult(new AssertException("AssertGT false, value is Null"));
        }
        if ("".equals(value)) {
            return new ExceptionResult(new AssertException("AssertGT false, value is Empty String"));
        }
        if (v instanceof Number) {
            try {
                double d = Double.parseDouble(value);
                if (d <= ((Number)v).doubleValue()) {
                    return new ExceptionResult(new AssertException("AssertGT false, value " + value + " is not great than " + v));
                }
                System.out.println("AssertGT true. value " + value + " is Great Than " + v);
                return new BooleanResult(Boolean.TRUE);
            }
            catch (NumberFormatException e) {
                return new ExceptionResult(new AssertException("AssertGT false, value is not Number:" + value));
            }
        }
        String v2 = v.toString();
        if (value.compareTo(v2) <= 0) {
            return new ExceptionResult(new AssertException("AssertGT false, value " + value + " is not great than " + v));
        }
        System.out.println("AssertGT true. value " + value + " is Great Than " + v);
        return new BooleanResult(Boolean.TRUE);
    }

    @Override
    public boolean needResolveParameter() {
        return true;
    }

    @Override
    public boolean laterExecute() {
        return false;
    }
}

