/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command.resulthandler;

import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.SerdeTool;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.bos.rpcrecorder.command.IResultHandler;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;

public class RPCResultHandler
implements IResultHandler {
    @Override
    public void handle(Context ctx, Object o) {
        String rpcObjectFileName;
        if (Policy.isOff(ctx, Policy.POLICY_OUTPUTRPCRESULT)) {
            return;
        }
        RPCResult result = (RPCResult)o;
        String scriptPath = (String)ctx.get("$scriptpath");
        String scriptName = (String)ctx.get("$scriptname");
        long scriptStartTime = Long.parseLong((String)ctx.get("_scriptstarttime_"));
        result.requestName = rpcObjectFileName = (String)ctx.get("_rpcobjectfilename_");
        if (result.requestName.endsWith(".xml") || result.requestName.endsWith(".rpc")) {
            result.requestName = result.requestName.substring(0, result.requestName.length() - 4);
        }
        File file = new File(scriptPath + "/" + scriptName + "_output" + "/result_" + Utils.formatSimpleTime(scriptStartTime));
        int tryindex = 0;
        while (tryindex++ < 20 && !file.exists() && !file.mkdirs()) {
            try {
                Thread.sleep(500 * tryindex);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String fileName = file.getAbsolutePath() + "/" + rpcObjectFileName;
        fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
        try {
            SerdeTool.saveObjectAsXML(result, fileName);
            System.out.println("Save Result As XML:" + fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

