/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.def;

import com.kingdee.bos.rpcrecorder.def.AbstractDef;
import com.kingdee.bos.rpcrecorder.def.CommentDef;
import com.kingdee.bos.rpcrecorder.def.EmptyLineDef;
import com.kingdee.bos.rpcrecorder.def.StatementDef;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class ScriptDef
extends AbstractDef {
    public AbstractDef[] defs;
    public String scriptPath;
    public String scriptName;

    @Override
    public void fromText(String txt) {
        StringReader sr = new StringReader(txt);
        BufferedReader br = new BufferedReader(sr);
        ArrayList<AbstractDef> list = new ArrayList<AbstractDef>();
        try {
            String line;
            int emptyCount = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) {
                    ++emptyCount;
                    continue;
                }
                if (emptyCount > 0) {
                    EmptyLineDef def = new EmptyLineDef();
                    def.count = emptyCount;
                    list.add(def);
                    emptyCount = 0;
                }
                list.add(this.guessDef(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.defs = list.toArray(new AbstractDef[list.size()]);
    }

    public AbstractDef guessDef(String line) {
        if (line.startsWith("//")) {
            line = line.substring(2);
            CommentDef def = new CommentDef();
            def.comment = line;
            return def;
        }
        StatementDef def = new StatementDef();
        def.fromText(line);
        return def;
    }

    @Override
    public String toText() {
        if (this.defs == null) {
            return null;
        }
        String txt = "";
        for (int i = 0; i < this.defs.length; ++i) {
            txt = txt + this.defs[i].toText();
        }
        return txt;
    }
}

