/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpc.impl.PrimitiveHold;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import org.jdom.Element;

public class PrimitiveSerdeProvider {
    public static void touch() {
    }

    static {
        XmlSerdeFactory.register(Byte.class, (IXmlSerde)new ByteSerde(Byte.class));
        XmlSerdeFactory.register(PrimitiveHold.ByteHold.class, (IXmlSerde)new ByteHoldSerde(PrimitiveHold.ByteHold.class));
        XmlSerdeFactory.register(Short.class, (IXmlSerde)new ShortSerde(Short.class));
        XmlSerdeFactory.register(PrimitiveHold.ShortHold.class, (IXmlSerde)new ShortHoldSerde(PrimitiveHold.ShortHold.class));
        XmlSerdeFactory.register(Integer.class, (IXmlSerde)new IntegerSerde(Integer.class));
        XmlSerdeFactory.register(PrimitiveHold.IntHold.class, (IXmlSerde)new IntHoldSerde(PrimitiveHold.IntHold.class));
        XmlSerdeFactory.register(Long.class, (IXmlSerde)new LongSerde(Long.class));
        XmlSerdeFactory.register(PrimitiveHold.LongHold.class, (IXmlSerde)new LongHoldSerde(PrimitiveHold.LongHold.class));
        XmlSerdeFactory.register(Float.class, (IXmlSerde)new FloatSerde(Float.class));
        XmlSerdeFactory.register(PrimitiveHold.FloatHold.class, (IXmlSerde)new FloatHoldSerde(PrimitiveHold.FloatHold.class));
        XmlSerdeFactory.register(Double.class, (IXmlSerde)new DoubleSerde(Double.class));
        XmlSerdeFactory.register(PrimitiveHold.DoubleHold.class, (IXmlSerde)new DoubleHoldSerde(PrimitiveHold.DoubleHold.class));
        XmlSerdeFactory.register(Boolean.class, (IXmlSerde)new BooleanSerde(Boolean.class));
        XmlSerdeFactory.register(PrimitiveHold.BooleanHold.class, (IXmlSerde)new BooleanHoldSerde(PrimitiveHold.BooleanHold.class));
        XmlSerdeFactory.register(PrimitiveHold.CharHold.class, (IXmlSerde)new CharHoldSerde(PrimitiveHold.CharHold.class));
    }

    static class BooleanSerde
    extends AbstractXmlSerde {
        protected BooleanSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Boolean.parseBoolean(s);
        }

        @Override
        public String getTagName() {
            return "Boolean";
        }
    }

    static class DoubleSerde
    extends AbstractXmlSerde {
        protected DoubleSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Double.parseDouble(s);
        }

        @Override
        public String getTagName() {
            return "Double";
        }
    }

    static class FloatSerde
    extends AbstractXmlSerde {
        protected FloatSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public String getTagName() {
            return "Float";
        }
    }

    static class LongSerde
    extends AbstractXmlSerde {
        protected LongSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Long.parseLong(s);
        }

        @Override
        public String getTagName() {
            return "Long";
        }
    }

    static class IntegerSerde
    extends AbstractXmlSerde {
        protected IntegerSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Integer.parseInt(s);
        }

        @Override
        public String getTagName() {
            return "Integer";
        }
    }

    static class ShortSerde
    extends AbstractXmlSerde {
        protected ShortSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Short.parseShort(s);
        }

        @Override
        public String getTagName() {
            return "Short";
        }
    }

    static class ByteSerde
    extends AbstractXmlSerde {
        protected ByteSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", object.toString());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return Byte.parseByte(s);
        }

        @Override
        public String getTagName() {
            return "Byte";
        }
    }

    static class BooleanHoldSerde
    extends AbstractXmlSerde {
        protected BooleanHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.BooleanHold value = (PrimitiveHold.BooleanHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            boolean v = Boolean.parseBoolean(s);
            return new PrimitiveHold.BooleanHold(v);
        }

        @Override
        public String getTagName() {
            return "boolean";
        }
    }

    static class CharHoldSerde
    extends AbstractXmlSerde {
        protected CharHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.CharHold value = (PrimitiveHold.CharHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            char v = s.charAt(0);
            return new PrimitiveHold.CharHold(v);
        }

        @Override
        public String getTagName() {
            return "char";
        }
    }

    static class DoubleHoldSerde
    extends AbstractXmlSerde {
        protected DoubleHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.DoubleHold value = (PrimitiveHold.DoubleHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            double v = Double.parseDouble(s);
            return new PrimitiveHold.DoubleHold(v);
        }

        @Override
        public String getTagName() {
            return "double";
        }
    }

    static class LongHoldSerde
    extends AbstractXmlSerde {
        protected LongHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.LongHold value = (PrimitiveHold.LongHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            long v = Long.parseLong(s);
            return new PrimitiveHold.LongHold(v);
        }

        @Override
        public String getTagName() {
            return "long";
        }
    }

    static class FloatHoldSerde
    extends AbstractXmlSerde {
        protected FloatHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.FloatHold value = (PrimitiveHold.FloatHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            float v = Float.parseFloat(s);
            return new PrimitiveHold.FloatHold(v);
        }

        @Override
        public String getTagName() {
            return "float";
        }
    }

    static class IntHoldSerde
    extends AbstractXmlSerde {
        protected IntHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.IntHold value = (PrimitiveHold.IntHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            int v = Integer.parseInt(s);
            return new PrimitiveHold.IntHold(v);
        }

        @Override
        public String getTagName() {
            return "int";
        }
    }

    static class ShortHoldSerde
    extends AbstractXmlSerde {
        protected ShortHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.ShortHold value = (PrimitiveHold.ShortHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            short v = Short.parseShort(s);
            return new PrimitiveHold.ShortHold(v);
        }

        @Override
        public String getTagName() {
            return "short";
        }
    }

    static class ByteHoldSerde
    extends AbstractXmlSerde {
        protected ByteHoldSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            PrimitiveHold.ByteHold value = (PrimitiveHold.ByteHold)object;
            element.setAttribute("value", "" + value.value);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            byte b = Byte.parseByte(s);
            return new PrimitiveHold.ByteHold(b);
        }

        @Override
        public String getTagName() {
            return "byte";
        }
    }
}

