/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import org.jdom.Element;

public class RPCRequestSerde
extends AbstractXmlSerde {
    public RPCRequestSerde(Class clazz) {
        super(clazz);
    }

    @Override
    public Element toXML(SerdeContext ctx, Class clazz, Object object) {
        Element element = this.createElement();
        element.setAttribute("version", ctx.getVersion());
        RPCRequest req = (RPCRequest)object;
        element.setAttribute("startTime", "" + req.startTime);
        element.setAttribute("endTime", "" + req.endTime);
        element.setAttribute("rpcCommand", "" + req.rpcCommand);
        Element modelEle = new Element("ModelInformation");
        modelEle.setAttribute("class", req.className);
        modelEle.setAttribute("model", req.model.getName());
        element.addContent(modelEle);
        Element methodEle = new Element("MethodInformation");
        methodEle.setAttribute("methodCode", "" + req.methodCode);
        methodEle.setAttribute("methodName", req.methodName);
        Element methodTypesEle = new Element("ParamTypes");
        methodTypesEle.addContent(ctx.toXML(req.methodArgTypes));
        Element methodValuesEle = new Element("ParamValues");
        methodValuesEle.addContent(ctx.toXML(req.methodArgs));
        methodEle.addContent(methodTypesEle);
        methodEle.addContent(methodValuesEle);
        element.addContent(methodEle);
        return element;
    }

    @Override
    public Object fromXML(SerdeContext ctx, Element element) {
        RPCRequest req = new RPCRequest();
        req.startTime = Long.parseLong(element.getAttributeValue("startTime"));
        req.endTime = Long.parseLong(element.getAttributeValue("endTime"));
        req.rpcCommand = Integer.parseInt(element.getAttributeValue("rpcCommand"));
        Element modelEle = element.getChild("ModelInformation");
        req.className = modelEle.getAttributeValue("class");
        String modelClassName = modelEle.getAttributeValue("model");
        try {
            req.model = SerdeUtils.classForName(modelClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Element methodEle = element.getChild("MethodInformation");
        req.methodCode = Integer.parseInt(methodEle.getAttributeValue("methodCode"));
        req.methodName = methodEle.getAttributeValue("methodName");
        Element paramTypesEle = methodEle.getChild("ParamTypes");
        Element paramValuesEle = methodEle.getChild("ParamValues");
        req.methodArgTypes = (Class[])ctx.fromXML((Element)paramTypesEle.getChildren().get(0));
        req.methodArgs = (Object[])ctx.fromXML((Element)paramValuesEle.getChildren().get(0));
        return req;
    }

    @Override
    public String getTagName() {
        return "RPCRequest";
    }
}

