/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class SerdeUtils {
    private static HashMap nameToClass = new HashMap();

    public static String identityId(Object object) {
        int hash = System.identityHashCode(object);
        String className = object.getClass().getName();
        return "" + hash + "." + className.length();
    }

    public static String encodeObject(Object object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RecorderException(e.getMessage());
        }
        byte[] buffer = bos.toByteArray();
        String strValue = Base64Encoder.byteArrayToBase64((byte[])buffer);
        return strValue;
    }

    public static Object decodeObject(String base64) {
        byte[] buffer = Base64Encoder.base64ToByteArray((String)base64);
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            return obj;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RecorderException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RecorderException(e);
        }
    }

    public static boolean isArray(String className) {
        return className.startsWith("[");
    }

    public static String friendName(String className) {
        if ("[I".equals(className)) {
            return "int_array";
        }
        if ("[S".equals(className)) {
            return "short_array";
        }
        if ("[B".equals(className)) {
            return "byte_array";
        }
        if ("[C".equals(className)) {
            return "char_array";
        }
        if ("[F".equals(className)) {
            return "float_array";
        }
        if ("[D".equals(className)) {
            return "double_array";
        }
        if ("[Z".equals(className)) {
            return "boolean_array";
        }
        return SerdeUtils.getArrayComponentClassName(className) + "_array";
    }

    public static String getArrayComponentClassName(String arrayClassName) {
        if (arrayClassName.startsWith("[L") && arrayClassName.endsWith(";")) {
            return arrayClassName.substring(2, arrayClassName.length() - 1);
        }
        if (arrayClassName.equals("[I")) {
            return "int";
        }
        if (arrayClassName.equals("[S")) {
            return "short";
        }
        if (arrayClassName.equals("[J")) {
            return "long";
        }
        if (arrayClassName.equals("[B")) {
            return "byte";
        }
        if (arrayClassName.equals("[C")) {
            return "char";
        }
        if (arrayClassName.equals("[F")) {
            return "float";
        }
        if (arrayClassName.equals("[D")) {
            return "double";
        }
        if (arrayClassName.equals("[Z")) {
            return "boolean";
        }
        throw new IllegalArgumentException("Not a array class:" + arrayClassName);
    }

    public static Class getArrayComponentClass(String arrayClassName) throws ClassNotFoundException {
        if (arrayClassName.startsWith("[L") && arrayClassName.endsWith(";")) {
            String name = arrayClassName.substring(2, arrayClassName.length() - 1);
            return SerdeUtils.classForName(name);
        }
        if (arrayClassName.equals("[I")) {
            return Integer.TYPE;
        }
        if (arrayClassName.equals("[S")) {
            return Short.TYPE;
        }
        if (arrayClassName.equals("[J")) {
            return Long.TYPE;
        }
        if (arrayClassName.equals("[B")) {
            return Byte.TYPE;
        }
        if (arrayClassName.equals("[C")) {
            return Character.TYPE;
        }
        if (arrayClassName.equals("[F")) {
            return Float.TYPE;
        }
        if (arrayClassName.equals("[D")) {
            return Double.TYPE;
        }
        if (arrayClassName.equals("[Z")) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException("Not a array class:" + arrayClassName);
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        Class clz = (Class)nameToClass.get(name);
        if (clz != null) {
            return clz;
        }
        clz = SerdeUtils.getPrimitiveClass(name);
        if (clz == null) {
            clz = SerdeUtils.getArrayClass(name);
        }
        if (clz == null) {
            clz = Class.forName(name);
        }
        nameToClass.put(name, clz);
        return clz;
    }

    public static Class getArrayClass(String name) {
        if (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            name = "[L" + name + ";";
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Class getPrimitiveClass(String name) {
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("char".equals(name)) {
            return Character.class;
        }
        if (name.equals("int[]")) {
            return int[].class;
        }
        if (name.equals("short[]")) {
            return short[].class;
        }
        if (name.equals("long[]")) {
            return long[].class;
        }
        if (name.equals("byte[]")) {
            return byte[].class;
        }
        if (name.equals("char[]")) {
            return char[].class;
        }
        if (name.equals("float[]")) {
            return float[].class;
        }
        if (name.equals("double[]")) {
            return double[].class;
        }
        if (name.equals("boolean[]")) {
            return boolean[].class;
        }
        return null;
    }
}

