/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import java.io.Serializable;
import org.jdom.Element;

public class UnknownObjectSerde
implements IXmlSerde {
    public static final UnknownObjectSerde instance = new UnknownObjectSerde();

    @Override
    public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
        ctx.markIdentityObject(object);
        Element element = new Element("UnknownObject");
        element.setAttribute("id", "" + SerdeUtils.identityId(object));
        String className = object.getClass().getName();
        element.setAttribute("class", className);
        Class<?> clz = null;
        try {
            clz = Class.forName(className);
            if (Serializable.class.isAssignableFrom(clz)) {
                element.setText(SerdeUtils.encodeObject(object));
            }
            if (object.toString() != null) {
                element.setAttribute("toString", object.toString());
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return element;
    }

    @Override
    public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
        String tagname = element.getName();
        if (!"UnknownObject".equals(tagname)) {
            throw new RecorderException("Not object element:" + tagname);
        }
        String s = element.getText();
        if (s != null && !"".equals(s)) {
            return SerdeUtils.decodeObject(s);
        }
        return null;
    }

    @Override
    public boolean accept(String type) {
        return true;
    }

    @Override
    public boolean isMultiMatch() {
        return false;
    }
}

