/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.core.rmi.RMIMonitorFactory;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpc.ObjectFactory;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpcwrapper.IRPCEngine;
import com.kingdee.bos.rpcwrapper.RMIEngineWrapper;
import com.kingdee.bos.rpcwrapper.RPCEngineWrapper;

public class RPCEngineFactory {
    public static synchronized IRPCEngine getEngine(String url) {
        RMIMonitorFactory.getRMIMonitor();
        if (ORMRPConfig.isUseOldRpc()) {
            return new RMIEngineWrapper(url);
        }
        return new RPCEngineWrapper(url);
    }

    public static synchronized void registerObjectFactory(IObjectFactory objectFactory) {
        if (ORMRPConfig.isUseOldRpc()) {
            ORMEngine.registerObjectFactory(objectFactory);
        } else {
            RPCEngine.registerObjectFactory(new ObjectFactoryWrapper(objectFactory));
        }
    }

    public static void addInvokeMonitor(InvokeMonitor monitor) {
        RPCConfig.addInvokeMonitor(monitor);
    }

    public static void addInvokeIntercepters(InvokeIntercepter intercepter) {
        RPCConfig.addInvokeIntercepter(intercepter);
    }

    private static final class ObjectFactoryWrapper
    implements ObjectFactory {
        private final IObjectFactory objectFactory;

        public ObjectFactoryWrapper(IObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
        }

        @Override
        public Object createObject(String name, Class model, Class[] argTypes, Object[] args) throws Exception {
            return this.objectFactory.createObject(name, model, argTypes, args);
        }

        @Override
        public Object createRemoteObject(String url, String name, Class model, Class[] argTypes, Object[] args) throws Exception {
            return this.objectFactory.createRemoteObject(url, name, model, argTypes, args);
        }
    }
}

