/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.bos.rpc.event.CloseEvent;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.IServerSessionListener;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.rpcwrapper.RPCSessionListenerWrapper;
import java.util.HashMap;

public class RPCSessionWrapper
implements ISession,
IServerSession {
    private static HashMap rpcSessionListenerWrapperTable = new HashMap();
    RPCServerSession serverSession;
    RPCSession session;

    RPCSessionWrapper(RPCServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public static RPCSessionWrapper getInstance(RPCServerSession serverSession) {
        return new RPCSessionWrapper(serverSession);
    }

    RPCSessionWrapper(RPCSession session) {
        this.session = session;
    }

    @Override
    public Object getDelegate() {
        return this.serverSession == null ? this.session : this.serverSession;
    }

    @Override
    public IORMModel createObject(String objectName, Class model) {
        return (IORMModel)this.session.createObject(objectName, model);
    }

    @Override
    public IORMModel createObject(String objectName, Class model, Class[] initArgTypes, Object[] initArgs) {
        return (IORMModel)this.session.createObject(objectName, model, initArgTypes, initArgs);
    }

    @Override
    public void put(Object key, Object value) {
        this.serverSession.putContext(key, value);
    }

    @Override
    public Object get(Object key) {
        if (this.serverSession != null) {
            return this.serverSession.getContext(key);
        }
        return null;
    }

    @Override
    public void addEventListener(IServerSessionListener listener) {
        RPCSessionListenerWrapper wrapper = new RPCSessionListenerWrapper(listener);
        rpcSessionListenerWrapperTable.put(listener, wrapper);
        this.serverSession.addEventListener(CloseEvent.class, wrapper);
    }

    @Override
    public void removeEventListener(IServerSessionListener listener) {
        RPCSessionListenerWrapper wrapper = (RPCSessionListenerWrapper)rpcSessionListenerWrapperTable.get(listener);
        if (wrapper != null) {
            this.serverSession.removeEventListener(CloseEvent.class, wrapper);
        }
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.serverSession != null) {
            this.serverSession.close();
        }
    }

    @Override
    public boolean isClosed() {
        if (this.session != null) {
            return this.session.isClosed();
        }
        if (this.serverSession != null) {
            return this.serverSession.isClosed();
        }
        return true;
    }

    public String toString() {
        if (this.session != null) {
            return this.session.toString();
        }
        if (this.serverSession != null) {
            return this.serverSession.toString();
        }
        return super.toString();
    }
}

