/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpcwrapper.IRemotePing;
import com.kingdee.bos.rpcwrapper.LongStat;
import com.kingdee.bos.rpcwrapper.PingThread;
import com.kingdee.bos.rpcwrapper.RemotePingResult;
import com.kingdee.util.StringUtils;
import java.io.PrintStream;

public class RemotePing
extends ORMObject
implements IRemotePing {
    private byte[] allocate;

    @Override
    public RemotePingResult ping(byte[] input, int returnSize, int calculateTimes, int allocate) {
        long tS = System.nanoTime();
        RemotePingResult rs = new RemotePingResult();
        this.calculate(calculateTimes);
        this.allocate(allocate);
        rs.data = new byte[returnSize];
        int b = 97;
        for (int n = 0; n < returnSize; ++n) {
            rs.data[n] = b;
            if ((b = (int)((byte)(b + 1))) != 107) continue;
            b = 97;
        }
        rs.serverTime = System.nanoTime() - tS;
        rs.inputSize = input.length;
        rs.returnSize = returnSize;
        return rs;
    }

    void allocate(int size) {
        this.allocate = new byte[size];
    }

    void calculate(int times) {
        for (int i = 0; i < times; ++i) {
            long n = 1L;
            for (int j = 1; j < 100; ++j) {
                n *= (long)j;
            }
        }
    }

    public static void main(String[] args) {
        String url = null;
        int inputSize = 0;
        int returnSize = 0;
        int calculateTimes = 0;
        int allocation = 0;
        int times = 1;
        int duration = 60000;
        int sessions = 1;
        int sleep = 500;
        boolean validate = true;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-server".equalsIgnoreCase(arg)) {
                url = args[++i];
            } else if ("-t".equalsIgnoreCase(arg)) {
                times = RemotePing.parseSize(args[++i]);
                validate = RemotePing.validate("t", times);
            } else if ("-input".equalsIgnoreCase(arg)) {
                inputSize = RemotePing.parseSize(args[++i]);
                validate = RemotePing.validate("input", inputSize);
            } else if ("-return".equalsIgnoreCase(arg)) {
                returnSize = RemotePing.parseSize(args[++i]);
                validate = RemotePing.validate("return", returnSize);
            } else if ("-calcu".equalsIgnoreCase(arg)) {
                calculateTimes = RemotePing.parseSize(args[++i]);
                validate = RemotePing.validate("calcu", calculateTimes);
            } else if ("-alloc".equalsIgnoreCase(arg)) {
                allocation = RemotePing.parseSize(args[++i]);
                validate = RemotePing.validate("alloc", allocation);
            } else if ("-duration".equalsIgnoreCase(arg)) {
                duration = RemotePing.parseSize(args[++i]);
            } else if ("-sessions".equalsIgnoreCase(arg)) {
                if ((sessions = RemotePing.parseSize(args[++i])) < 1) {
                    sessions = 1;
                }
            } else if ("-sleep".equalsIgnoreCase(arg) && (sleep = RemotePing.parseSize(args[++i])) < 500) {
                sleep = 500;
            }
            if (validate) continue;
            return;
        }
        if (StringUtils.isEmpty(url) || !url.toLowerCase().startsWith("tcp://") && !url.toLowerCase().startsWith("tcps://") && !url.toLowerCase().startsWith("http://")) {
            RemotePing.printUseage();
            return;
        }
        RemotePing.pingRPCServer(url, sessions, inputSize, returnSize, calculateTimes, allocation, times, duration, sleep, System.out);
    }

    public static void pingRPCServer(String url, int sessions, int inputSize, int returnSize, int calculateTimes, int allocation, int times, int duration, int waitTime, PrintStream output) {
        for (int k = 0; k < sessions; ++k) {
            PingThread thread = new PingThread("pingThread" + k);
            thread.url = url;
            thread.inputSize = inputSize;
            thread.returnSize = returnSize;
            thread.calculateTimes = calculateTimes;
            thread.allocation = allocation;
            thread.times = times;
            thread.duration = duration;
            thread.waitTimes = waitTime;
            thread.output = output;
            thread.start();
        }
    }

    public static LongStat pingRPCServer(String url, int inputSize, int times, PrintStream output) {
        PingThread thread = new PingThread("pingThread");
        thread.url = url;
        thread.inputSize = inputSize;
        thread.returnSize = inputSize;
        thread.calculateTimes = 1;
        thread.allocation = 1024;
        thread.times = times;
        thread.duration = 1;
        thread.waitTimes = 500L;
        thread.output = output;
        thread.run();
        return thread.getResponseTimeStat();
    }

    public static void pingRPCServerLongtime(String url, int times, int duration, int waitTime, PrintStream output) {
        PingThread thread = new PingThread("pingThread0");
        thread.url = url;
        thread.inputSize = 1024;
        thread.returnSize = 1024;
        thread.calculateTimes = 1000;
        thread.allocation = 1024;
        thread.times = times;
        thread.duration = duration;
        thread.waitTimes = waitTime;
        thread.output = output;
        thread.start();
    }

    static boolean validate(String argName, int size) {
        if (size < 0) {
            System.out.println("arg " + argName + " need a number");
            RemotePing.printUseage();
            return false;
        }
        return true;
    }

    static int parseSize(String sSize) {
        sSize = sSize.toLowerCase().trim();
        int factor = 1;
        if (sSize.endsWith("k")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 1024;
        } else if (sSize.endsWith("m")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 0x100000;
        }
        try {
            int size = Integer.parseInt(sSize);
            return size * factor;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static void printUseage() {
        System.out.println("java -cp [classpath] com.kingdee.bos.rpcwrapper.RemotePing [options]");
        System.out.println("options is:");
        System.out.println("                -server     :rpc server url (for example tcp://localhost:11034)");
        System.out.println("                [-sessions] :sessions (default 1) ");
        System.out.println("                [-duration] :duration (default 1000*60ms )");
        System.out.println("                [-sleep]    :sleep (default 500ms )");
        System.out.println("                -t          :ping times");
        System.out.println("                -input      :input data size (for example  2k,512)");
        System.out.println("                -return     :return data size (for example 2k,512)");
        System.out.println("                -calcu      :calculate Times (for example 1000)");
        System.out.println("                -alloc      :allocation memory size (for example 512k,10m)");
    }
}

