/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper.lbmon;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LBMonClient {
    private static Logger logger = Logger.getLogger(LBMonClient.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            LBMonClient.printUsage();
            return;
        }
        ORMRPConfig.loadConfig();
        int port = ServerManager.getConfig().lbMonPort;
        if ("STOP".equalsIgnoreCase(args[0])) {
            boolean b;
            if (args.length > 1) {
                try {
                    port = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (b = LBMonClient.stopLBServer(port)) {
                System.out.println("Send Command [STOP] Successfully!");
            }
            return;
        }
        if ("STAT".equalsIgnoreCase(args[0])) {
            if (args.length > 1) {
                try {
                    port = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Map result = LBMonClient.statisticsLBServer(port);
            System.out.println("STAT IS" + result.toString());
            return;
        }
        if ("register".equalsIgnoreCase(args[0])) {
            if (args.length > 3) {
                try {
                    port = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String command = args[0] + " " + args[1] + " " + args[2];
            try {
                LBMonClient.sendCommand("localhost", port, command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if ("unregister".equalsIgnoreCase(args[0])) {
            if (args.length > 2) {
                try {
                    port = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String command = args[0] + " " + args[1];
            try {
                LBMonClient.sendCommand("localhost", port, command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        LBMonClient.printUsage();
    }

    private static void printUsage() {
        System.out.println("Usage: 1)stop [port]");
        System.out.println("2)stat [port]");
        System.out.println("3)register url performanceFactor [port]");
        System.out.println("4)unregister url");
    }

    public static boolean stopLBServer(int port) {
        try {
            LBMonClient.sendCommand("localhost", port, "STOP");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Map statisticsLBServer(int port) {
        try {
            return LBMonClient.processStatisticsCommand("localhost", port);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sendCommand(String hostName, int hostPort, String cmd) throws IOException {
        Socket socket = null;
        try {
            String str;
            socket = new Socket(hostName, hostPort);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            writer.println(cmd);
            System.out.println("client:" + cmd);
            do {
                str = in.readLine();
                System.out.println("server:" + str);
                if (StringUtils.isEmpty((String)str)) return;
            } while (!"OK".equalsIgnoreCase(str));
            return;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static Map processStatisticsCommand(String hostName, int hostPort) throws IOException {
        Socket socket = null;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            socket = new Socket(hostName, hostPort);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            writer.println("STAT");
            logger.debug((Object)"client:STAT");
            String str = in.readLine();
            logger.debug((Object)("server:" + str));
            if (!"OK".equalsIgnoreCase(str)) {
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            while (true) {
                str = in.readLine();
                logger.debug((Object)("server:" + str));
                if (StringUtils.isEmpty((String)str)) break;
                if ("END".equalsIgnoreCase(str)) {
                    break;
                }
                int index = str.indexOf("=");
                if (index <= 0) continue;
                String key = str.substring(0, index);
                String value = str.substring(index + 1);
                result.put(key, value);
            }
        }
        catch (ConnectException ce) {
            logger.error((Object)("Connect Exception: hostName " + hostName + " port " + hostPort));
            throw ce;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {}
            }
        }
        return result;
    }
}

