/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper.lbmon;

import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.ILoadBalanceServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.log4j.Logger;

public class LBMonitor {
    private MonitorThread monitorThread;
    private ILoadBalanceServer balanceServer;
    private Logger logger = Logger.getLogger(LBMonitor.class);
    private long interval = 10000L;

    public LBMonitor(ILoadBalanceServer balanceServer) {
        this.monitorThread = new MonitorThread();
        this.balanceServer = balanceServer;
    }

    public int getMonitorPort() {
        return ServerManager.getConfig().lbMonPort;
    }

    public void start() {
        this.monitorThread.start();
    }

    class CommandProcessThread
    extends Thread {
        private Socket socket;
        private final BufferedReader in;
        private final PrintWriter out;
        private String clientHost;

        public CommandProcessThread(Socket socket) throws IOException {
            super("LBSMCommandProcesser");
            this.socket = null;
            this.socket = socket;
            this.clientHost = socket.getInetAddress().toString();
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String command = this.in.readLine();
                if ("END".equalsIgnoreCase(command)) {
                } else {
                    this.out.println("OK");
                    this.processCommand(command);
                }
            }
            catch (IOException ioe) {
                LBMonitor.this.logger.error((Object)ioe, (Throwable)ioe);
            }
            finally {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void processCommand(String command) {
            if ("STOP".equalsIgnoreCase(command)) {
                LBMonitor.this.balanceServer.shutdown();
                LBMonitor.this.logger.warn((Object)("LoadBalanceServer Shutdown by " + this.clientHost));
                System.exit(0);
            }
            if ("STAT".equalsIgnoreCase(command)) {
                Map result = LBMonitor.this.balanceServer.statistics();
                if (result != null) {
                    this.printStatistics(this.out, result);
                }
                this.out.println("END");
                return;
            }
            String[] sa = command.split(" ");
            if (sa[0].equalsIgnoreCase("register")) {
                LBMonitor.this.balanceServer.registerServer(sa[1], Float.parseFloat(sa[2]));
                return;
            }
            if (sa[0].equalsIgnoreCase("unregister")) {
                LBMonitor.this.balanceServer.unregisterServer(sa[1]);
                return;
            }
        }

        private void printStatistics(PrintWriter writer, Map statistics) {
            for (String key : statistics.keySet()) {
                String value = statistics.get(key).toString();
                writer.println(key + "=" + value);
            }
        }
    }

    class MonitorThread
    extends Thread {
        ServerSocket serverSocket;

        MonitorThread() {
            super("LBSM");
            this.serverSocket = null;
        }

        @Override
        public void run() {
            int port = LBMonitor.this.getMonitorPort();
            if (ServerManager.getConfig((String)"loadbalance").standby) {
                LBMonitor.this.logger.info((Object)("LoadBalance Monitor Standby on " + port));
                while (true) {
                    try {
                        Socket sock = new Socket(InetAddress.getByName(null), port);
                        IOUtil.close(sock);
                    }
                    catch (UnknownHostException e) {
                        LBMonitor.this.logger.error((Object)e, (Throwable)e);
                    }
                    catch (IOException e1) {
                        break;
                    }
                    try {
                        Thread.sleep(LBMonitor.this.interval);
                    }
                    catch (InterruptedException e) {
                        LBMonitor.this.logger.error((Object)e, (Throwable)e);
                        return;
                    }
                }
            }
            try {
                this.serverSocket = new ServerSocket(port, 0, InetAddress.getByName(null));
                LBMonitor.this.logger.info((Object)("LoadBalance Monitor Start Listen on " + this.serverSocket.getLocalSocketAddress().toString()));
            }
            catch (IOException ioe) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                LBMonitor.this.logger.error((Object)ioe, (Throwable)ioe);
                return;
            }
            Socket s = null;
            while (true) {
                try {
                    while (true) {
                        s = this.serverSocket.accept();
                        CommandProcessThread t = new CommandProcessThread(s);
                        t.start();
                    }
                }
                catch (IOException e) {
                    if (s == null) continue;
                    try {
                        s.close();
                    }
                    catch (IOException ignore) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

