/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import com.kingdee.bos.tcpmonitor.DataRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class DataReader {
    public final File recFile;
    public final File reqFile;
    public final File resFile;
    public final ArrayList recs = new ArrayList();
    long req_size = 0L;
    long res_size = 0L;

    public DataReader(File recFile) {
        this.recFile = recFile;
        String s = recFile.getAbsolutePath();
        this.reqFile = new File(s.substring(0, s.length() - 3) + ".request");
        this.resFile = new File(s.substring(0, s.length() - 3) + ".response");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadData(DataRecord rec) throws IOException {
        RandomAccessFile in = rec.type == 301 ? new RandomAccessFile(this.reqFile, "r") : new RandomAccessFile(this.resFile, "r");
        try {
            in.seek(rec.pos);
            byte[] b = new byte[rec.len];
            in.readFully(b);
            byte[] byArray = b;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.recs.clear();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.recFile)));
        this.req_size = this.reqFile.length();
        this.res_size = this.resFile.length();
        try {
            int count = (int)this.recFile.length() / 16;
            for (int i = 0; i < count; ++i) {
                DataRecord rec = new DataRecord(in);
                if (!(rec.type == 301 ? rec.pos + (long)rec.len > this.req_size : rec.pos + (long)rec.len > this.res_size)) {
                    this.recs.add(rec);
                    continue;
                }
                break;
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        RandomAccessFile in = new RandomAccessFile(this.recFile, "r");
        this.req_size = this.reqFile.length();
        this.res_size = this.resFile.length();
        try {
            int count = (int)in.length() / 16;
            long pos = (long)this.recs.size() * 16L;
            in.seek(pos);
            count -= this.recs.size();
            for (int i = 0; i < count; ++i) {
                DataRecord rec = new DataRecord(in);
                if (!(rec.type == 301 ? rec.pos + (long)rec.len > this.req_size : rec.pos + (long)rec.len > this.res_size)) {
                    this.recs.add(rec);
                    continue;
                }
                break;
            }
        }
        finally {
            in.close();
        }
    }
}

