/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import com.kingdee.bos.tcpmonitor.Connection;
import com.kingdee.bos.tcpmonitor.DataRecord;
import com.kingdee.bos.tcpmonitor.MonitorConfig;
import com.kingdee.bos.tcpmonitor.PhysicalResource;
import com.kingdee.bos.tcpmonitor.Util;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class DataStoreFile
extends PhysicalResource {
    static final Logger logger = Logger.getLogger((String)"tcpmonitor.DataStoreFile");
    public static final int REQUEST_DATA = 301;
    public static final int RESPONSE_DATA = 302;
    public File recFile;
    private DataOutputStream record = null;
    private OutputStream request = null;
    private OutputStream response = null;
    private DataRecord rec = null;
    private long request_pos = 0L;
    private long response_pos = 0L;

    @Override
    protected synchronized void finalOpen() throws IOException {
        String s = this.recFile.getAbsolutePath();
        this.recFile.getParentFile().mkdirs();
        this.record = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.recFile)));
        this.request = new BufferedOutputStream(new FileOutputStream(s.substring(0, s.length() - 3) + ".request"));
        this.response = new BufferedOutputStream(new FileOutputStream(s.substring(0, s.length() - 3) + ".response"));
    }

    private void flush(OutputStream out) {
        try {
            if (out != null) {
                out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void flush() {
        this.flush(this.record);
        this.flush(this.request);
        this.flush(this.response);
    }

    DataStoreFile(Connection cn) {
        File path = MonitorConfig.dumpPath != null ? new File(MonitorConfig.dumpPath) : new File("./");
        path = path.getAbsoluteFile();
        path = new File(path, "" + cn.server.bindPort);
        String remote = cn.server.remoteHost + "_" + cn.server.remotePort;
        path = new File(path, remote);
        InetSocketAddress addr = (InetSocketAddress)cn.sock.getRemoteSocketAddress();
        path = new File(path, addr.getAddress().getHostAddress());
        this.recFile = new File(path, cn.id + "_" + addr.getPort() + ".rec");
    }

    public synchronized void writeRecord(int type, byte[] b, int off, int len) {
        try {
            this.open();
            if (this.rec != null && this.rec.type == type) {
                this.rec.len += len;
            } else {
                if (this.rec != null) {
                    this.rec.write(this.record);
                }
                this.rec = new DataRecord(type, System.currentTimeMillis(), type == 302 ? this.response_pos : this.request_pos, len);
            }
            if (type == 302) {
                this.response.write(b, off, len);
                this.response_pos += (long)len;
            } else {
                this.request.write(b, off, len);
                this.request_pos += (long)len;
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected synchronized void finalClose() {
        try {
            if (this.rec != null) {
                this.rec.write(this.record);
            }
            this.rec = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.close(this.record);
        Util.close(this.request);
        Util.close(this.response);
        this.record = null;
        this.request = null;
        this.response = null;
    }
}

