/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import com.kingdee.bos.tcpmonitor.Connection;
import com.kingdee.bos.tcpmonitor.EventListener;
import com.kingdee.bos.tcpmonitor.MonitorConfig;
import com.kingdee.bos.tcpmonitor.MonitorEvent;
import com.kingdee.bos.tcpmonitor.TcpServer;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EventManager {
    private static final Logger logger = Logger.getLogger((String)"tcpmonitor.EventManager");
    private static final ArrayList listeners = new ArrayList();
    private static EventListener[] ls = null;

    public static synchronized EventListener[] getListeners() {
        if (ls == null) {
            ls = new EventListener[listeners.size()];
            listeners.toArray(ls);
        }
        return ls;
    }

    public static synchronized void addListener(EventListener l) {
        listeners.add(l);
        ls = null;
    }

    public static synchronized void removeListener(EventListener l) {
        listeners.remove(l);
        ls = null;
    }

    static void serverCreated(TcpServer server) {
        EventManager.fireEvent(new MonitorEvent(101, server));
    }

    static void serverDeleted(TcpServer server) {
        EventManager.fireEvent(new MonitorEvent(104, server));
    }

    static void serverStart(TcpServer server) {
        EventManager.fireEvent(new MonitorEvent(102, server));
    }

    static void serverStoped(TcpServer server) {
        EventManager.fireEvent(new MonitorEvent(103, server));
    }

    static void connectionOpened(Connection cn) {
        EventManager.fireEvent(new MonitorEvent(201, cn));
    }

    static void connectionClosed(Connection cn) {
        EventManager.fireEvent(new MonitorEvent(202, cn));
    }

    static void processEvent(MonitorEvent event) {
        EventListener[] ls = EventManager.getListeners();
        for (int i = 0; i < ls.length; ++i) {
            ls[i].onEvent(event);
        }
    }

    public static void fireEvent(MonitorEvent event) {
        if (event.id > 100 && event.id < 299 && logger.isInfoEnabled()) {
            logger.info((Object)event.toString());
        } else if (event.id > 300 && event.id < 399 && MonitorConfig.logBlockData && logger.isDebugEnabled()) {
            logger.debug((Object)event.toString());
        }
        EventManager.processEvent(event);
    }
}

