/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import com.kingdee.bos.tcpmonitor.Connection;
import com.kingdee.bos.tcpmonitor.TcpServer;

public class MonitorEvent {
    public static final int SERVER_CREATED = 101;
    public static final int SERVER_START = 102;
    public static final int SERVER_STOP = 103;
    public static final int SERVER_DELETE = 104;
    public static final int CONNECTION_OPEN = 201;
    public static final int CONNECTION_CLOSE = 202;
    public static final int REQUEST_DATA = 301;
    public static final int RESPONSE_DATA = 302;
    public final int id;
    public final Object source;
    public final long time;
    public final Object parameter;

    public MonitorEvent(int id, Object source, Object parameter) {
        this.id = id;
        this.source = source;
        this.parameter = parameter;
        this.time = System.currentTimeMillis();
    }

    public MonitorEvent(int id, Object source) {
        this(id, source, null);
    }

    public TcpServer getServer() {
        if (this.source != null && this.source instanceof TcpServer) {
            return (TcpServer)this.source;
        }
        if (this.source != null && this.source instanceof Connection) {
            return ((Connection)this.source).server;
        }
        return null;
    }

    public Connection getConnection() {
        if (this.source != null && this.source instanceof Connection) {
            return (Connection)this.source;
        }
        return null;
    }

    public String getEventName(int id) {
        switch (id) {
            case 101: {
                return "SERVER_CREATED";
            }
            case 104: {
                return "SERVER_DELETE";
            }
            case 102: {
                return "SERVER_START";
            }
            case 103: {
                return "SERVER_STOP";
            }
            case 201: {
                return "CONNECTION_OPEN";
            }
            case 202: {
                return "CONNECTION_CLOSE";
            }
            case 301: {
                return "REQUEST_DATA";
            }
            case 302: {
                return "RESPONSE_DATA";
            }
        }
        return "(" + id + ")";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getEventName(this.id));
        sb.append(" ");
        sb.append(this.source);
        if (this.parameter != null) {
            sb.append(" ");
            if (this.parameter instanceof byte[]) {
                sb.append(((byte[])this.parameter).length);
                sb.append(" byte(s)");
            } else {
                sb.append(this.parameter);
            }
        }
        return sb.toString();
    }
}

