/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import java.io.IOException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public abstract class PhysicalResource {
    static final Logger logger = Logger.getLogger((String)"tcpmonitor.PhysicalResource");
    protected volatile boolean closed = true;
    private static final HashSet ress = new HashSet();

    protected abstract void finalClose();

    protected abstract void finalOpen() throws IOException;

    public void flush() {
    }

    public final void open() throws IOException {
        if (this.closed) {
            this.closed = false;
            this.finalOpen();
            PhysicalResource.addResource(this);
        }
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            PhysicalResource.removeResource(this);
            this.finalClose();
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addResource(PhysicalResource res) {
        HashSet hashSet = ress;
        synchronized (hashSet) {
            ress.add(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeResource(PhysicalResource res) {
        HashSet hashSet = ress;
        synchronized (hashSet) {
            ress.remove(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushResources() {
        Object[] ss;
        HashSet hashSet = ress;
        synchronized (hashSet) {
            ss = ress.toArray();
        }
        if (ss != null && ss.length > 0) {
            for (int i = 0; i < ss.length; ++i) {
                ((PhysicalResource)ss[i]).flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseResources() {
        Object[] ss;
        HashSet hashSet = ress;
        synchronized (hashSet) {
            ss = ress.toArray();
        }
        if (ss != null && ss.length > 0) {
            logger.info((Object)"close physical resources.");
            for (int i = 0; i < ss.length; ++i) {
                ((PhysicalResource)ss[i]).close();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("SystemResource-Releaser"){

            @Override
            public void run() {
                PhysicalResource.releaseResources();
            }
        });
    }
}

