/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import com.kingdee.bos.tcpmonitor.Connection;
import com.kingdee.bos.tcpmonitor.EventManager;
import com.kingdee.bos.tcpmonitor.ServerManager;
import com.kingdee.bos.tcpmonitor.Util;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class TcpServer {
    static final Logger logger = Logger.getLogger((String)"tcpmonitor.TcpServer");
    public final int bindPort;
    public final String remoteHost;
    public final int remotePort;
    private final ArrayList conns = new ArrayList();
    private ServerSocket serverSocket = null;
    private Thread listenerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection[] getConnections() {
        ArrayList arrayList = this.conns;
        synchronized (arrayList) {
            Connection[] cs = new Connection[this.conns.size()];
            this.conns.toArray(cs);
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionCount() {
        ArrayList arrayList = this.conns;
        synchronized (arrayList) {
            return this.conns.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newConnection(Socket sock) {
        Socket sock2 = null;
        try {
            sock2 = new Socket(this.remoteHost, this.remotePort);
        }
        catch (IOException e) {
            logger.warn((Object)("connect to " + this.remoteHost + ":" + this.remotePort + " failed. " + e.toString()));
        }
        Connection cn = new Connection(this, sock, sock2);
        ArrayList arrayList = this.conns;
        synchronized (arrayList) {
            this.conns.add(cn);
        }
    }

    public String toString() {
        return this.getTitle();
    }

    public String getTitle() {
        return "TcpServer(bind=" + this.bindPort + ",remote=" + this.remoteHost + ":" + this.remotePort + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        if (this == x) {
            return true;
        }
        if (!(x instanceof TcpServer)) {
            return false;
        }
        return this.toString().equals(x.toString());
    }

    TcpServer(int bindPort, String remoteHost, int remotePort) {
        this.bindPort = bindPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public synchronized boolean isAlive() {
        return this.listenerThread != null && this.listenerThread.isAlive();
    }

    public synchronized void start() throws IOException {
        if (this.isAlive()) {
            return;
        }
        this.serverSocket = new ServerSocket(this.bindPort);
        this.listenerThread = new Thread(this.getTitle()){

            @Override
            public void run() {
                TcpServer.this.service();
            }
        };
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public synchronized void stop() throws InterruptedException {
        Thread t = this.listenerThread;
        this.clear();
        if (t != null) {
            t.join();
        }
    }

    private void clear() {
        Util.close(this.serverSocket);
        this.serverSocket = null;
        this.listenerThread = null;
    }

    private void service() {
        EventManager.serverStart(this);
        try {
            while (true) {
                Socket sock = this.serverSocket.accept();
                this.newConnection(sock);
            }
        }
        catch (Throwable throwable) {
            this.clear();
            EventManager.serverStoped(this);
            return;
        }
    }

    public static void usage() {
        System.out.println("usage: java " + TcpServer.class.getName() + " bindPort remoteHost remotePort");
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            if (args == null || args.length != 3) {
                TcpServer.usage();
                return;
            }
            int bindPort = Integer.parseInt(args[0]);
            String remoteHost = args[1];
            int remotePort = Integer.parseInt(args[2]);
            TcpServer server = ServerManager.createServer(bindPort, remoteHost, remotePort);
            server.start();
            server.listenerThread.join();
        }
        catch (Throwable e) {
            e.printStackTrace();
            TcpServer.usage();
        }
    }
}

