/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor.ui;

import com.kingdee.bos.tcpmonitor.DataReader;
import com.kingdee.bos.tcpmonitor.DataRecord;
import com.kingdee.bos.tcpmonitor.PhysicalResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class RecordViewer
extends JPanel {
    private JTextArea textArea;
    private JList list;
    private JLabel recordsLabel;
    private DefaultListModel listModel = new DefaultListModel();
    private JCheckBox chText;
    private Font defaultFont = new Font("\u5b8b\u4f53", 0, 15);
    private JFileChooser fc = null;
    private DataReader data = null;

    public RecordViewer() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.3);
        this.add((Component)splitPane, "Center");
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setLeftComponent(scrollPane);
        this.list = new JList(this.listModel);
        this.list.setFont(new Font("\u5b8b\u4f53", 0, 14));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RecordViewer.this.selectRecord();
            }
        });
        scrollPane.setViewportView(this.list);
        this.recordsLabel = new JLabel();
        this.recordsLabel.setHorizontalAlignment(0);
        this.recordsLabel.setOpaque(true);
        scrollPane.setColumnHeaderView(this.recordsLabel);
        this.recordsLabel.setText("Records");
        JScrollPane scrollPane_1 = new JScrollPane();
        splitPane.setRightComponent(scrollPane_1);
        this.textArea = new JTextArea();
        this.textArea.setFont(this.defaultFont);
        this.textArea.setEditable(false);
        scrollPane_1.setViewportView(this.textArea);
        JLabel label = new JLabel();
        scrollPane_1.setColumnHeaderView(label);
        label.setText("          00 01 02 03 04 05 06 07  08 09 0A 0B 0C 0D 0E 0F");
        label.setFont(this.defaultFont);
        JToolBar toolBar = new JToolBar();
        this.add((Component)toolBar, "North");
        JButton browseButton = new JButton();
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordViewer.this.browse();
            }
        });
        browseButton.setText("Browse");
        toolBar.add(browseButton);
        toolBar.addSeparator();
        this.chText = new JCheckBox();
        this.chText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordViewer.this.selectRecord();
            }
        });
        this.chText.setText("Text");
        toolBar.add(this.chText);
        toolBar.addSeparator();
        JButton refreshButton = new JButton();
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordViewer.this.refresh();
            }
        });
        refreshButton.setText("Refresh");
        toolBar.add(refreshButton);
    }

    public void browse() {
        try {
            if (this.fc == null) {
                this.fc = new JFileChooser(new File("./"));
                this.fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".rec");
                    }

                    @Override
                    public String getDescription() {
                        return "Record file(*.rec)";
                    }
                });
            }
            if (this.fc.showOpenDialog(this) == 0) {
                this.load(this.fc.getSelectedFile());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void load(File recFile) {
        try {
            PhysicalResource.flushResources();
            if (this.data != null && this.data.recFile.equals(recFile)) {
                this.refresh();
            }
            this.data = new DataReader(recFile);
            this.data.load();
            this.listModel.clear();
            this.refreshRecords();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void refreshRecords() throws Exception {
        for (int i = this.listModel.size(); i < this.data.recs.size(); ++i) {
            this.listModel.addElement(this.data.recs.get(i));
        }
        this.selectRecord();
        this.recordsLabel.setText("(" + this.data.recs.size() + ") records");
    }

    public void refresh() {
        PhysicalResource.flushResources();
        try {
            if (this.data != null) {
                this.data.refresh();
                this.refreshRecords();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void selectRecord() {
        DataRecord rec = (DataRecord)this.list.getSelectedValue();
        if (rec == null) {
            this.textArea.setText("");
        } else {
            try {
                byte[] b = this.data.loadData(rec);
                this.textArea.setText(this.parseData(b));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private String parseData(byte[] b) throws Exception {
        if (this.chText.isSelected()) {
            return new String(b);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; i += 16) {
            this.parseLine(sb, b, i);
        }
        return sb.toString();
    }

    private String fixVal(int val, int len) {
        String s = "0000000000000000" + Integer.toHexString(val).toUpperCase();
        return s.substring(s.length() - len);
    }

    private void parseLine(StringBuffer sb, byte[] b, int off) {
        sb.append(this.fixVal(off, 8));
        sb.append(":");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int index;
            sb.append(" ");
            if (i == 8) {
                sb.append(" ");
            }
            if ((index = i + off) >= b.length) {
                sb.append("  ");
                s.append(" ");
                continue;
            }
            int bVal = 0xFF & b[index];
            sb.append(this.fixVal(bVal, 2));
            if (bVal >= 32 && bVal < 128) {
                s.append((char)bVal);
                continue;
            }
            s.append(".");
        }
        sb.append("  ; ");
        sb.append(s.toString());
        sb.append("\n");
    }
}

