/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor.ui;

import com.kingdee.bos.tcpmonitor.Connection;
import com.kingdee.bos.tcpmonitor.EventListener;
import com.kingdee.bos.tcpmonitor.EventManager;
import com.kingdee.bos.tcpmonitor.MonitorEvent;
import com.kingdee.bos.tcpmonitor.ServerManager;
import com.kingdee.bos.tcpmonitor.TcpServer;
import com.kingdee.bos.tcpmonitor.ui.NewDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ServerPanel
extends JPanel {
    private JToolBar toolBar;
    private JButton btnNew;
    private JButton btnStart;
    private JButton btnDelete;
    private JButton btnStop;
    public static final int REFRESH_INTERVAL = 1000;
    private TableTableModel tableModel = new TableTableModel();
    private JTable table;
    private JList list;
    private DefaultListModel listModel = new DefaultListModel();
    private Timer timer;
    private volatile boolean needRefresh = true;
    TcpServer server = null;
    Connection[] cns = null;
    private NewDialog dlgNew = null;

    public ServerPanel() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.3);
        this.add(splitPane);
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setLeftComponent(scrollPane);
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServerPanel.this.refreshSelections();
            }
        });
        scrollPane.setViewportView(this.list);
        JLabel serversLabel = new JLabel();
        serversLabel.setHorizontalAlignment(0);
        scrollPane.setColumnHeaderView(serversLabel);
        serversLabel.setText("Servers");
        JScrollPane scrollPane_1 = new JScrollPane();
        splitPane.setRightComponent(scrollPane_1);
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        scrollPane_1.setViewportView(this.table);
        this.toolBar = new JToolBar();
        this.add((Component)this.toolBar, "North");
        this.btnNew = new JButton();
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPanel.this.newServer();
            }
        });
        this.btnNew.setText("New Server");
        this.toolBar.add(this.btnNew);
        this.toolBar.addSeparator();
        this.btnDelete = new JButton();
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPanel.this.deleteServer();
            }
        });
        this.btnDelete.setText("Delete");
        this.toolBar.add(this.btnDelete);
        this.toolBar.addSeparator();
        this.btnStart = new JButton();
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPanel.this.startServer();
            }
        });
        this.btnStart.setText("Start");
        this.toolBar.add(this.btnStart);
        this.toolBar.addSeparator();
        this.btnStop = new JButton();
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPanel.this.stopServer();
            }
        });
        this.btnStop.setText("Stop ");
        this.toolBar.add(this.btnStop);
        EventManager.addListener(new MonitorListener());
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ServerPanel.this.needRefresh) {
                    ServerPanel.this.refreshServers();
                }
            }
        });
        this.timer.start();
    }

    public void refreshServers() {
        this.needRefresh = false;
        TcpServer[] ss = ServerManager.getServers();
        int i1 = 0;
        int i2 = 0;
        while (true) {
            TcpServer s1 = null;
            if (i1 < ss.length) {
                s1 = ss[i1];
            }
            TcpServer s2 = null;
            if (i2 < this.listModel.size()) {
                s2 = (TcpServer)this.listModel.get(i2);
            }
            if (s1 == null && s2 == null) break;
            if (s1 == s2) {
                ++i1;
                ++i2;
                continue;
            }
            if (s2 != null) {
                this.listModel.remove(i2);
                continue;
            }
            this.listModel.addElement(s1);
            ++i1;
        }
        this.refreshConnections();
    }

    public void refreshConnections() {
        this.server = (TcpServer)this.list.getSelectedValue();
        if (this.server != null) {
            this.cns = this.server.getConnections();
        }
        boolean b = this.server != null;
        boolean a = false;
        if (this.server != null) {
            a = this.server.isAlive();
        }
        this.btnStart.setEnabled(b && !a);
        this.btnStop.setEnabled(b && a);
        this.btnDelete.setEnabled(b);
        this.tableModel.fireTableDataChanged();
    }

    private void refreshSelections() {
        if (this.server != this.list.getSelectedValue()) {
            this.refreshConnections();
        }
    }

    private Object _getValueAt(int rowIndex, int columnIndex) {
        if (this.cns == null || rowIndex >= this.cns.length) {
            return null;
        }
        Connection cn = this.cns[rowIndex];
        switch (columnIndex) {
            case 0: {
                return cn.id;
            }
            case 1: {
                return cn.sock.getRemoteSocketAddress();
            }
            case 2: {
                return cn.sock2.getRemoteSocketAddress();
            }
            case 3: {
                return cn.isClosed() ? "closed" : " connected";
            }
            case 4: {
                return cn.requestBytes;
            }
            case 5: {
                return cn.responseBytes;
            }
        }
        return null;
    }

    public void newServer() {
        if (this.dlgNew == null) {
            this.dlgNew = new NewDialog();
        }
        if (this.dlgNew.showDialog()) {
            try {
                TcpServer svr = ServerManager.createServer(this.dlgNew.getBindPort(), this.dlgNew.getRemoteHost(), this.dlgNew.getRemotePort());
                svr.start();
                this.listModel.addElement(svr);
                this.list.setSelectedIndex(this.listModel.size() - 1);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void startServer() {
        try {
            if (this.server != null) {
                this.server.start();
                this.refreshConnections();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void stopServer() {
        try {
            if (this.server != null) {
                this.server.stop();
                this.refreshConnections();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void deleteServer() {
        try {
            if (this.server != null) {
                this.server.stop();
                ServerManager.removeServer(this.server);
                this.refreshServers();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private int _getRowCount() {
        if (this.cns == null) {
            return 0;
        }
        return this.cns.length;
    }

    private class MonitorListener
    implements EventListener {
        private MonitorListener() {
        }

        @Override
        public void onEvent(MonitorEvent event) {
            ServerPanel.this.needRefresh = true;
        }
    }

    class TableTableModel
    extends AbstractTableModel {
        public final String[] COLUMN_NAMES = new String[]{"id", "Client", "Server", "State", "Request", "Response"};

        TableTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ServerPanel.this._getValueAt(rowIndex, columnIndex);
        }

        @Override
        public int getRowCount() {
            return ServerPanel.this._getRowCount();
        }
    }
}

